/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import net.sf.jstuff.core.logging.Logger;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.eclipse.jdt.annotation.Nullable;

public class ExtendedBeanDeserializer
extends BeanDeserializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.create();

    public static final void registerWith(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig cfg, BeanDescription beanDescr, JsonDeserializer<?> deserializer) {
                if (deserializer instanceof BeanDeserializer) {
                    return new ExtendedBeanDeserializer((BeanDeserializerBase)((BeanDeserializer)deserializer));
                }
                return deserializer;
            }
        });
        mapper.registerModule((Module)module);
    }

    public ExtendedBeanDeserializer(BeanDeserializerBase src) {
        super(src);
    }

    private @Nullable Object getParentObject(JsonParser p) {
        JsonStreamContext parentCtx = p.getParsingContext().getParent();
        if (parentCtx == null) {
            return null;
        }
        Object parentObject = parentCtx.getCurrentValue();
        if (parentObject == null) {
            return null;
        }
        if ((parentObject instanceof Collection || parentObject instanceof Map || parentObject.getClass().isArray()) && (parentCtx = parentCtx.getParent()) != null) {
            parentObject = parentCtx.getCurrentValue();
        }
        return parentObject;
    }

    protected Object deserializeFromObjectUsingNonDefault(JsonParser p, DeserializationContext ctxt) throws IOException {
        Constructor ctor;
        Object parentObject = this.getParentObject(p);
        if (parentObject != null && (ctor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this._beanType.getRawClass(), (Class[])new Class[]{parentObject.getClass()})) != null) {
            try {
                Object bean = ctor.newInstance(parentObject);
                p.setCurrentValue(bean);
                if (p.hasTokenId(5)) {
                    String propName = p.getCurrentName();
                    do {
                        p.nextToken();
                        SettableBeanProperty prop = this._beanProperties.find(propName);
                        if (prop == null) {
                            this.handleUnknownVanilla(p, ctxt, bean, propName);
                            continue;
                        }
                        try {
                            prop.deserializeAndSet(p, ctxt, bean);
                        }
                        catch (Exception e) {
                            this.wrapAndThrow(e, bean, propName, ctxt);
                        }
                    } while ((propName = p.nextFieldName()) != null);
                }
                return bean;
            }
            catch (ReflectiveOperationException ex) {
                LOG.warn((Throwable)ex);
            }
        }
        return super.deserializeFromObjectUsingNonDefault(p, ctxt);
    }
}

