/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.ldap;

import java.util.Hashtable;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import net.sf.jstuff.core.functional.Invocable;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.ldap.LdapException;
import net.sf.jstuff.integration.ldap.LdapUtils;
import org.eclipse.jdt.annotation.NonNull;

public class LdapTemplate {
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private Hashtable<String, Object> ldapSettings = (Hashtable)NullAnalysisHelper.lazyNonNull();
    private String ldapURL = (String)NullAnalysisHelper.lazyNonNull();
    private boolean pooled = true;
    private boolean useStartTSL = false;

    public <T> T execute(Invocable<T, @NonNull LdapContext, ? extends Exception> callback) {
        Object object;
        InitialLdapContext ctx = null;
        StartTlsResponse tls = null;
        try {
            ctx = new InitialLdapContext(this.ldapSettings, null);
            if (this.useStartTSL) {
                tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                tls.negotiate();
            }
            object = callback.invoke((Object)ctx);
        }
        catch (Exception ex) {
            try {
                throw new LdapException(ex);
            }
            catch (Throwable throwable) {
                LdapUtils.closeQuietly(tls);
                LdapUtils.closeQuietly(ctx);
                throw throwable;
            }
        }
        LdapUtils.closeQuietly(tls);
        LdapUtils.closeQuietly(ctx);
        return (T)object;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public String getLdapURL() {
        return this.ldapURL;
    }

    @PostConstruct
    public void initialize() {
        this.ldapSettings = new Hashtable();
        this.ldapSettings.put("java.naming.factory.initial", this.initialContextFactory);
        this.ldapSettings.put("java.naming.provider.url", this.ldapURL);
        this.ldapSettings.put("java.naming.referral", "throw");
        if (this.pooled) {
            this.ldapSettings.put("com.sun.jndi.ldap.connect.pool", "true");
        }
    }

    public boolean isPooled() {
        return this.pooled;
    }

    public boolean isUseStartTSL() {
        return this.useStartTSL;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    @Inject
    public void setLdapURL(String ldapURL) {
        this.ldapURL = ldapURL;
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public void setUseStartTSL(boolean useStartTSL) {
        this.useStartTSL = useStartTSL;
    }
}

