/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.ldap;

import java.io.IOException;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.StartTlsResponse;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.validation.Args;
import org.eclipse.jdt.annotation.Nullable;

public abstract class LdapUtils {
    public static void closeQuietly(@Nullable Context context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException namingException) {}
    }

    public static void closeQuietly(@Nullable StartTlsResponse tls) {
        try {
            if (tls != null) {
                tls.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static <T> T getAttributeValue(@Nullable SearchResult sr, String attrName, T ifNullOrNotExisting) throws NamingException {
        if (sr == null) {
            return ifNullOrNotExisting;
        }
        return LdapUtils.getAttributeValue(sr.getAttributes(), attrName, ifNullOrNotExisting);
    }

    public static <T> T getAttributeValue(@Nullable Attributes attrs, String attrName, T ifNullOrNotExisting) throws NamingException {
        if (attrs == null) {
            return ifNullOrNotExisting;
        }
        return LdapUtils.getAttributeValue(attrs.get(attrName), ifNullOrNotExisting);
    }

    public static <T> T getAttributeValue(@Nullable Attribute attr, T ifNullOrNotExisting) throws NamingException {
        if (attr == null) {
            return ifNullOrNotExisting;
        }
        try {
            Object obj = attr.get();
            if (obj == null) {
                return ifNullOrNotExisting;
            }
            return (T)obj;
        }
        catch (NoSuchElementException noSuchElementException) {
            return ifNullOrNotExisting;
        }
    }

    public static CharSequence ldapEscape(String text) {
        Args.notNull((String)"text", (Object)text);
        int textLen = text.length();
        if (textLen == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(textLen + 16);
        int i = 0;
        while (i < textLen) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    sb.append("\\5c");
                    break;
                }
                case '(': {
                    sb.append("\\28");
                    break;
                }
                case ')': {
                    sb.append("\\29");
                    break;
                }
                case '*': {
                    sb.append("\\2a");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb;
    }

    public static String prettifyDN(String dn) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = Strings.split((String)dn, (char)',');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String chunk = stringArray[n2];
            String[] pair = Strings.split((String)chunk, (String)"=", (int)2);
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(pair[0].trim().toUpperCase());
            sb.append('=');
            sb.append(pair[1].trim());
            ++n2;
        }
        return sb.toString();
    }
}

