/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.persistence;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.validation.Args;
import org.eclipse.jdt.annotation.Nullable;

public abstract class SQLUtils {
    public static String buildInsertSQL(String tableName, String ... columnNames) {
        Args.notEmpty((String)"tableName", (CharSequence)tableName);
        Args.notEmpty((String)"columnNames", (Object[])columnNames);
        if (columnNames.length == 1) {
            return "INSERT INTO " + tableName + "(" + columnNames[0] + ") VALUES (?)";
        }
        return "INSERT INTO " + tableName + "(" + Strings.join((Object[])columnNames, (String)",") + ") VALUES (" + Strings.repeat((String)"?,", (int)(columnNames.length - 1)) + "?)";
    }

    public static PreparedStatement buildInsertStatement(Connection con, String tableName, Map<String, Object> columns) throws SQLException {
        Args.notNull((String)"con", (Object)con);
        Args.notEmpty((String)"tableName", (CharSequence)tableName);
        Args.notEmpty((String)"columns", columns);
        String[] columnNames = columns.keySet().toArray(new String[columns.size()]);
        PreparedStatement stmt = con.prepareStatement(SQLUtils.buildInsertSQL(tableName, columnNames));
        int parameterIndex = 1;
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            stmt.setObject(parameterIndex, columns.get(columnName));
            ++parameterIndex;
            ++n2;
        }
        return stmt;
    }

    public static String buildUpdateSQL(String tableName, String ... columnNames) {
        Args.notEmpty((String)"tableName", (CharSequence)tableName);
        Args.notEmpty((String)"columnNames", (Object[])columnNames);
        return SQLUtils.buildUpdateSQL(tableName, columnNames, null);
    }

    public static String buildUpdateSQL(String tableName, String[] columnNames, @Nullable String where) {
        Args.notEmpty((String)"tableName", (CharSequence)tableName);
        Args.notEmpty((String)"columnNames", (Object[])columnNames);
        if (columnNames.length == 1) {
            return "UPDATE " + tableName + " SET " + columnNames[0] + " = ? " + (where == null ? "" : " WHERE " + where);
        }
        return "UPDATE " + tableName + " SET " + Strings.join((Object[])columnNames, (String)" = ?, ") + " = ? " + (where == null ? "" : " WHERE " + where);
    }

    public static PreparedStatement buildUpdateStatement(Connection con, String tableName, Map<String, Object> columns, String where, Object ... whereValues) throws SQLException {
        Args.notNull((String)"con", (Object)con);
        Args.notEmpty((String)"tableName", (CharSequence)tableName);
        Args.notEmpty((String)"columns", columns);
        String[] columnNames = columns.keySet().toArray(new String[columns.size()]);
        PreparedStatement stmt = con.prepareStatement(SQLUtils.buildUpdateSQL(tableName, columnNames, where));
        int parameterIndex = 1;
        Object[] objectArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = objectArray[n2];
            stmt.setObject(parameterIndex, columns.get(columnName));
            ++parameterIndex;
            ++n2;
        }
        if (whereValues != null && whereValues.length > 0) {
            objectArray = whereValues;
            n = whereValues.length;
            n2 = 0;
            while (n2 < n) {
                Object val = objectArray[n2];
                stmt.setObject(parameterIndex, val);
                ++parameterIndex;
                ++n2;
            }
        }
        return stmt;
    }

    public static Map<String, Integer> getColumnInfo(Connection con, String tableName) throws SQLException {
        Args.notNull((String)"con", (Object)con);
        Args.notEmpty((String)"tableName", (CharSequence)tableName);
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        ResultSet rs = con.getMetaData().getColumns("%", "%", tableName, "%");
        while (rs.next()) {
            m.put(rs.getString("COLUMN_NAME").toLowerCase(), rs.getInt("DATA_TYPE"));
        }
        rs.close();
        return m;
    }

    public static int getSQLType(Class<?> type) {
        if (type == Integer.class || type == Integer.TYPE || type == Short.class || type == Short.TYPE) {
            return 4;
        }
        if (type == Long.class || type == Long.TYPE || type == Byte.class || type == Byte.TYPE) {
            return 4;
        }
        if (type == Float.class || type == Float.TYPE || type == Double.class || type == Double.TYPE) {
            return 6;
        }
        if (type == BigDecimal.class) {
            return 6;
        }
        if (type == String.class) {
            return 12;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return 16;
        }
        if (type == java.util.Date.class || type == Date.class) {
            return 91;
        }
        if (type == Time.class) {
            return 92;
        }
        if (type == Timestamp.class) {
            return 93;
        }
        if (type == byte[].class) {
            return -3;
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static boolean tableExists(Connection con, String tableName) throws SQLException {
        Args.notNull((String)"con", (Object)con);
        Args.notEmpty((String)"tableName", (CharSequence)tableName);
        Statement stmt = null;
        ResultSet results = null;
        try {
            stmt = con.prepareStatement("SELECT COUNT(*) FROM " + tableName + " WHERE 0 = 1");
            results = stmt.executeQuery();
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
        finally {
            if (results != null) {
                results.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }
}

