/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.persistence.h2;

import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import org.eclipse.jdt.annotation.Nullable;
import org.h2.tools.Server;

public class H2ServerSpringBean {
    private static final Logger LOG = Logger.create();
    private String dataDir = (String)NullAnalysisHelper.lazyNonNull();
    private boolean enabled = true;
    private int tcpPort = 10040;
    private @Nullable Server tcpServer;
    private boolean webAllowOthers;
    private boolean webEnabled;
    private int webPort = 8040;
    private @Nullable Server webServer;

    public H2ServerSpringBean() {
        LOG.infoNew((Object)this);
    }

    @PreDestroy
    public void destroy() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.tcpServer != null) {
            this.tcpServer.stop();
        }
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getWebPort() {
        return this.webPort;
    }

    @PostConstruct
    public void initialize() {
        if (this.enabled) {
            try {
                Server tcpServer = this.tcpServer = (Server)NullAnalysisHelper.asNonNullUnsafe((Object)Server.createTcpServer((String[])new String[]{"-tcpPort", Integer.toString(this.tcpPort), "-baseDir", this.dataDir}));
                tcpServer.start();
                LOG.info("Embedded H2 Databases are now available via: jdbc:h2:tcp://localhost:" + this.tcpPort + "/<DATABASE_NAME>");
                if (this.webEnabled) {
                    Server webServer = this.webServer = (Server)NullAnalysisHelper.asNonNullUnsafe((Object)Server.createWebServer((String[])new String[]{"-webPort", Integer.toString(this.webPort), "-webAllowOthers", Boolean.toString(this.webAllowOthers)}));
                    webServer.start();
                    LOG.info("H2 UI is now available via: http://localhost:" + this.webPort);
                }
            }
            catch (SQLException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isWebAllowOthers() {
        return this.webAllowOthers;
    }

    public boolean isWebEnabled() {
        return this.webEnabled;
    }

    @Inject
    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTcpPort(int tcpPort) {
        this.tcpPort = tcpPort;
    }

    public void setWebAllowOthers(boolean webAllowOthers) {
        this.webAllowOthers = webAllowOthers;
    }

    public void setWebEnabled(boolean webEnabled) {
        this.webEnabled = webEnabled;
    }

    public void setWebPort(int webPort) {
        this.webPort = webPort;
    }
}

