/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.persistence.jpa;

import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;

public abstract class JPAUtils {
    public static String enumerateQuestionMarks(String queryString) {
        if (queryString.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        int startSearchAt = 0;
        int foundAt = 0;
        int i = 1;
        while ((foundAt = queryString.indexOf(63, startSearchAt)) >= 0) {
            String replaceValue = "?" + i;
            out.append(queryString, startSearchAt, foundAt).append(replaceValue);
            startSearchAt = foundAt + 1;
            ++i;
        }
        return out.append(queryString, startSearchAt, queryString.length()).toString();
    }

    public static final void executeTransactional(EntityManager em, Runnable code) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        try {
            code.run();
            tx.commit();
        }
        catch (RuntimeException ex) {
            tx.rollback();
            throw ex;
        }
    }

    public static final <T> T executeTransactional(EntityManager em, Supplier<T> code) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        try {
            T result = code.get();
            tx.commit();
            return result;
        }
        catch (RuntimeException ex) {
            tx.rollback();
            throw ex;
        }
    }

    public static final <T> T mergeTransactional(EntityManager em, T entity) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        try {
            Object result = em.merge(entity);
            tx.commit();
            return (T)result;
        }
        catch (RuntimeException ex) {
            tx.rollback();
            throw ex;
        }
    }

    public static void setParameters(Query query, Object ... parameters) {
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                query.setParameter(i + 1, parameters[i]);
                ++i;
            }
        }
    }
}

