/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.persistence.spring;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.Assert;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.ResultSetDynaClass;
import org.eclipse.jdt.annotation.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;

public class BeanResultSetExtractor<T>
implements ResultSetExtractor<List<T>> {
    private static final Logger LOG = Logger.create();
    private Class<T> beanClass = (Class)NullAnalysisHelper.lazyNonNull();
    private Map<String, String> beanPropertiesLowerCase = (Map)NullAnalysisHelper.lazyNonNull();

    public BeanResultSetExtractor(Class<T> beanClass) throws IntrospectionException {
        this.setBeanClass(beanClass);
    }

    public @Nullable List<T> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
        Assert.notNull(this.beanClass, (String)"Property beanClass must be set.");
        ArrayList<Object> extractedBeans = new ArrayList<Object>();
        for (DynaBean dynaBean : new ResultSetDynaClass(resultSet, true)) {
            Object bean = null;
            try {
                bean = this.getBeanClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DynaProperty[] dynaPropertyArray = dynaBean.getDynaClass().getDynaProperties();
                int n = dynaPropertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DynaProperty dynaProp = dynaPropertyArray[n2];
                    String dynaPropName = dynaProp.getName();
                    Object dynaPropValue = dynaBean.get(dynaPropName);
                    String beanPropName = this.beanPropertiesLowerCase.get(dynaPropName);
                    BeanUtils.copyProperty(bean, (String)beanPropName, (Object)dynaPropValue);
                    ++n2;
                }
                extractedBeans.add(bean);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex, "Unexpected error occurred while processing DynaBean.\n beanClass=%s\n bean=%s\n dynaBean=%s", new Object[]{this.beanClass, Strings.toString(bean), Strings.toString((Object)dynaBean)});
            }
        }
        return extractedBeans;
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<T> beanClass) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        HashMap<String, String> propsLowerCase = new HashMap<String, String>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor prop = propertyDescriptorArray[n2];
            String propName = prop.getName();
            if (propsLowerCase.put(propName.toLowerCase(), propName) != null) {
                throw new IllegalStateException("Bean Class " + beanClass.getName() + " contains multiple properties with same lowercase representation: " + propName);
            }
            ++n2;
        }
        this.beanClass = beanClass;
        this.beanPropertiesLowerCase = propsLowerCase;
    }
}

