/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.persistence.spring;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.ResultSetDynaClass;
import org.apache.commons.beanutils.converters.DateConverter;
import org.springframework.jdbc.core.RowMapper;

public class BeanRowMapper<T>
implements RowMapper<T> {
    private static final Logger LOG = Logger.create();
    private static final BeanUtilsBean BUB;
    private Class<T> beanClass = (Class)NullAnalysisHelper.lazyNonNull();
    private Map<String, String> beanPropertyNames = (Map)NullAnalysisHelper.lazyNonNull();
    private final WeakHashMap<ResultSet, ResultSetDynaClass> rsDynaClassesCache = new WeakHashMap();

    static {
        ConvertUtilsBean converter = new ConvertUtilsBean();
        converter.register((Converter)new DateConverter(null), Date.class);
        BUB = new BeanUtilsBean(converter);
    }

    public BeanRowMapper(Class<T> beanClass) throws IntrospectionException {
        Args.notNull((String)"beanClass", beanClass);
        this.setBeanClass(beanClass);
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetDynaClass rsDynaClass = this.rsDynaClassesCache.get(rs);
        if (rsDynaClass == null) {
            rsDynaClass = new ResultSetDynaClass(rs, true);
            this.rsDynaClassesCache.put(rs, rsDynaClass);
        }
        try {
            T bean = this.getBeanClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DynaProperty[] dynaPropertyArray = rsDynaClass.getDynaProperties();
            int n = dynaPropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                DynaProperty dynaProp = dynaPropertyArray[n2];
                String dynaPropName = dynaProp.getName();
                Object dynaPropValue = rsDynaClass.getObjectFromResultSet(dynaPropName);
                String beanPropName = this.beanPropertyNames.get(dynaPropName);
                BUB.copyProperty(bean, beanPropName, dynaPropValue);
                ++n2;
            }
            return bean;
        }
        catch (RuntimeException | SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            throw new SQLException(ex.getMessage());
        }
    }

    protected void setBeanClass(Class<T> beanClass) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        HashMap<String, String> propsLowerCase = new HashMap<String, String>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor prop = propertyDescriptorArray[n2];
            String propName = prop.getName();
            if (propsLowerCase.put(propName.toLowerCase(), propName) != null) {
                throw new IllegalStateException("Bean Class " + beanClass.getName() + " contains multiple properties with same lowercase representation: " + propName);
            }
            ++n2;
        }
        this.beanClass = beanClass;
        this.beanPropertyNames = propsLowerCase;
    }
}

