/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.portlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.portlet.RenderResponse;
import javax.portlet.filter.RenderResponseWrapper;
import net.sf.jstuff.core.io.stream.FastByteArrayOutputStream;
import org.eclipse.jdt.annotation.Nullable;

public class ContentCapturingRenderResponseWrapper
extends RenderResponseWrapper {
    private @Nullable PrintWriter exposedPrintWriter;
    private final FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();

    public ContentCapturingRenderResponseWrapper(RenderResponse response) {
        super(response);
    }

    public void clear() {
        this.outputStream.reset();
    }

    public byte[] toByteArray() {
        return this.outputStream.toByteArray();
    }

    public String toString() {
        if (this.exposedPrintWriter != null) {
            this.exposedPrintWriter.flush();
        }
        try {
            String encoding = this.getCharacterEncoding();
            return this.outputStream.toString(encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public OutputStream getPortletOutputStream() {
        if (this.exposedPrintWriter != null) {
            throw new IllegalStateException("getWriter() was called already!");
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() {
        PrintWriter exposedPrintWriter = this.exposedPrintWriter;
        if (exposedPrintWriter == null) {
            exposedPrintWriter = this.exposedPrintWriter = new PrintWriter(new Writer(){

                @Override
                public void write(String str) throws IOException {
                    ContentCapturingRenderResponseWrapper.this.outputStream.write(str.getBytes(ContentCapturingRenderResponseWrapper.this.getCharacterEncoding()));
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    ContentCapturingRenderResponseWrapper.this.outputStream.write(new String(cbuf, off, len).getBytes(ContentCapturingRenderResponseWrapper.this.getCharacterEncoding()));
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            }){

                @Override
                public void write(String str) {
                    try {
                        ContentCapturingRenderResponseWrapper.this.outputStream.write(str.getBytes(ContentCapturingRenderResponseWrapper.this.getCharacterEncoding()));
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        }
        return exposedPrintWriter;
    }
}

