/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.serviceregistry.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.sf.jstuff.core.reflection.Types;
import net.sf.jstuff.integration.serviceregistry.ServiceUnavailableException;
import net.sf.jstuff.integration.serviceregistry.impl.DefaultServiceProxyAdvice;
import net.sf.jstuff.integration.serviceregistry.impl.DefaultServiceRegistry;
import net.sf.jstuff.integration.serviceregistry.impl.ServiceProxyInternal;
import org.eclipse.jdt.annotation.Nullable;

public class ByteBuddyServiceRegistry
extends DefaultServiceRegistry {
    @Override
    protected <SERVICE_INTERFACE> ServiceProxyInternal<SERVICE_INTERFACE> createServiceProxy(DefaultServiceRegistry.ServiceEndpointState serviceEndpointState, Class<SERVICE_INTERFACE> serviceInterface) {
        MethodDelegation interceptor = MethodDelegation.to(new ByteBuddyServiceInterceptor<SERVICE_INTERFACE>(serviceEndpointState, serviceInterface));
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().subclass(DefaultServiceProxyAdvice.class, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_PUBLIC).implement(new Type[]{serviceInterface}).method((ElementMatcher)ElementMatchers.isDeclaredBy(serviceInterface)).intercept((Implementation)interceptor);
        for (Class iface : Types.getInterfacesRecursive(serviceInterface)) {
            builder = builder.implement(new Type[]{iface}).method((ElementMatcher)ElementMatchers.isDeclaredBy((Class)iface)).intercept((Implementation)interceptor);
        }
        DynamicType.Loaded clazz = builder.make().load(DefaultServiceRegistry.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER);
        DefaultServiceProxyAdvice proxy = (DefaultServiceProxyAdvice)Types.newInstance((Class)clazz.getLoaded(), (Object[])new Object[]{serviceEndpointState, serviceInterface});
        proxy.setProxy(proxy);
        return proxy;
    }

    protected static final class ByteBuddyServiceInterceptor<SERVICE_INTERFACE> {
        private final DefaultServiceRegistry.ServiceEndpointState serviceEndpointState;
        private final Class<SERVICE_INTERFACE> serviceInterface;

        protected ByteBuddyServiceInterceptor(DefaultServiceRegistry.ServiceEndpointState serviceEPState, Class<SERVICE_INTERFACE> serviceInterface) {
            this.serviceEndpointState = serviceEPState;
            this.serviceInterface = serviceInterface;
        }

        @RuntimeType
        public @Nullable Object intercept(@Origin Method method, Object ... args) throws Exception {
            SERVICE_INTERFACE service = this.serviceEndpointState.getActiveServiceIfCompatible(this.serviceInterface);
            if (service == null) {
                throw new ServiceUnavailableException(this.serviceEndpointState.getServiceEndpointId(), this.serviceInterface);
            }
            return method.invoke(service, args);
        }
    }
}

