/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.serviceregistry.impl;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.jstuff.core.collection.WeakHashSet;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.reflection.Proxies;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.serviceregistry.ServiceEndpoint;
import net.sf.jstuff.integration.serviceregistry.ServiceProxy;
import net.sf.jstuff.integration.serviceregistry.ServiceRegistry;
import net.sf.jstuff.integration.serviceregistry.ServiceUnavailableException;
import net.sf.jstuff.integration.serviceregistry.impl.DefaultServiceEndpoint;
import net.sf.jstuff.integration.serviceregistry.impl.DefaultServiceProxyAdvice;
import net.sf.jstuff.integration.serviceregistry.impl.DefaultServiceRegistryMBean;
import net.sf.jstuff.integration.serviceregistry.impl.ServiceProxyInternal;
import org.eclipse.jdt.annotation.Nullable;

public class DefaultServiceRegistry
implements ServiceRegistry,
DefaultServiceRegistryMBean {
    private static final Logger LOG = Logger.create();
    private final Map<String, ServiceEndpointState> serviceEndpoints = new HashMap<String, ServiceEndpointState>();
    private final Lock serviceEndpoints_READ;
    private final Lock serviceEndpoints_WRITE;

    public DefaultServiceRegistry() {
        LOG.infoNew((Object)this);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.serviceEndpoints_READ = lock.readLock();
        this.serviceEndpoints_WRITE = lock.writeLock();
    }

    private void _cleanup() {
        LOG.debug("Cleaning up service endpoints...");
        Iterator<Map.Entry<String, ServiceEndpointState>> it = this.serviceEndpoints.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ServiceEndpointState> entry = it.next();
            ServiceEndpointState cfg = entry.getValue();
            if (cfg.activeService != null) continue;
            cfg.checkStrongProxies();
            if (!cfg.issuedServiceProxiesWeak.isEmpty() || !cfg.issuedServiceProxiesStrong.isEmpty()) continue;
            LOG.debug("Purging endpoint config for [%s]", (Object)cfg.serviceEndpointId);
            it.remove();
        }
    }

    @Override
    public <SERVICE_INTERFACE> boolean addService(Class<SERVICE_INTERFACE> serviceInterface, SERVICE_INTERFACE serviceInstance) throws IllegalArgumentException, IllegalStateException {
        Args.notNull((String)"serviceInterface", serviceInterface);
        Args.notNull((String)"serviceInstance", serviceInstance);
        return this.addService(serviceInterface.getName(), serviceInterface, serviceInstance);
    }

    @Override
    public <SERVICE_INTERFACE> boolean addService(String serviceEndpointId, Class<SERVICE_INTERFACE> serviceInterface, SERVICE_INTERFACE serviceInstance) throws IllegalArgumentException, IllegalStateException {
        Args.notNull((String)"serviceEndpointId", (Object)serviceEndpointId);
        Args.notNull((String)"serviceInterface", serviceInterface);
        Args.notNull((String)"serviceInstance", serviceInstance);
        if (!serviceInterface.isInterface()) {
            throw new IllegalArgumentException("[serviceInterface] must be an interface");
        }
        this.serviceEndpoints_WRITE.lock();
        try {
            ServiceEndpointState srvConfig = this.serviceEndpoints.get(serviceEndpointId);
            if (srvConfig == null) {
                srvConfig = new ServiceEndpointState(serviceEndpointId);
                this.serviceEndpoints.put(serviceEndpointId, srvConfig);
            }
            if (srvConfig.activeService == null) {
                srvConfig.setActiveService(serviceInterface, serviceInstance);
                this._cleanup();
                return true;
            }
            if (srvConfig.activeService == serviceInstance) {
                return false;
            }
            throw new IllegalStateException("Cannot register service [" + serviceInstance + "] at endpoint [" + serviceEndpointId + "] because service [" + srvConfig.activeService + "] is already registered.");
        }
        finally {
            this.serviceEndpoints_WRITE.unlock();
        }
    }

    protected <SERVICE_INTERFACE> ServiceProxyInternal<SERVICE_INTERFACE> createServiceProxy(ServiceEndpointState serviceEndpointState, Class<SERVICE_INTERFACE> serviceInterface) {
        DefaultServiceProxyAdvice advice = new DefaultServiceProxyAdvice(serviceEndpointState, serviceInterface);
        ServiceProxyInternal serviceProxy = (ServiceProxyInternal)Proxies.create((proxy, method, args) -> {
            Object service;
            if (method.getDeclaringClass() == ServiceProxy.class || method.getDeclaringClass() == ServiceProxyInternal.class) {
                return method.invoke((Object)advice, args);
            }
            String methodName = method.getName();
            int methodParamCount = method.getParameterTypes().length;
            if (methodParamCount == 0) {
                if ("hashCode".equals(methodName)) {
                    return advice.hashCode();
                }
                if ("toString".equals(methodName)) {
                    return advice.toString();
                }
            } else if (methodParamCount == 1 && "equals".equals(methodName)) {
                if (proxy == NullAnalysisHelper.asNonNullUnsafe((Object[])args)[0]) {
                    return true;
                }
                return false;
            }
            if ((service = serviceEndpointState.getActiveServiceIfCompatible(serviceInterface)) == null) {
                throw new ServiceUnavailableException(defaultServiceProxyAdvice.serviceEndpointId, serviceInterface);
            }
            try {
                return method.invoke(service, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }, (Class[])new Class[]{ServiceProxyInternal.class, serviceInterface});
        advice.setProxy(serviceProxy);
        return serviceProxy;
    }

    public List<ServiceEndpoint> getActiveServiceEndpoints() {
        this.serviceEndpoints_READ.lock();
        try {
            ArrayList<ServiceEndpoint> result = new ArrayList<ServiceEndpoint>();
            for (ServiceEndpointState sep : this.serviceEndpoints.values()) {
                if (sep.activeServiceInterface == null) continue;
                result.add(new DefaultServiceEndpoint(sep.serviceEndpointId, sep.activeServiceInterface));
            }
            ArrayList<ServiceEndpoint> arrayList = result;
            return arrayList;
        }
        finally {
            this.serviceEndpoints_READ.unlock();
        }
    }

    @Override
    public <SERVICE_INTERFACE> ServiceProxy<SERVICE_INTERFACE> getService(String serviceEndpointId, Class<SERVICE_INTERFACE> serviceInterface) {
        ServiceProxyInternal<SERVICE_INTERFACE> proxy;
        ServiceEndpointState srvConfig;
        Args.notNull((String)"serviceEndpointId", (Object)serviceEndpointId);
        Args.notNull((String)"serviceInterface", serviceInterface);
        this.serviceEndpoints_READ.lock();
        try {
            srvConfig = this.serviceEndpoints.get(serviceEndpointId);
            if (srvConfig != null && (proxy = srvConfig.findServiceProxy(serviceInterface)) != null) {
                ServiceProxyInternal<SERVICE_INTERFACE> serviceProxyInternal = proxy;
                return serviceProxyInternal;
            }
        }
        finally {
            this.serviceEndpoints_READ.unlock();
        }
        this.serviceEndpoints_WRITE.lock();
        try {
            srvConfig = this.serviceEndpoints.get(serviceEndpointId);
            if (srvConfig == null) {
                srvConfig = new ServiceEndpointState(serviceEndpointId);
                this.serviceEndpoints.put(serviceEndpointId, srvConfig);
            }
            ServiceProxyInternal<SERVICE_INTERFACE> serviceProxyInternal = proxy = srvConfig.findOrCreateServiceProxy(serviceInterface);
            return serviceProxyInternal;
        }
        finally {
            this.serviceEndpoints_WRITE.unlock();
        }
    }

    @Override
    public Set<String> getServiceEndpointIds() {
        this.serviceEndpoints_READ.lock();
        try {
            TreeSet<String> result = new TreeSet<String>();
            for (ServiceEndpointState sep : this.serviceEndpoints.values()) {
                if (sep.activeService == null) continue;
                result.add(sep.serviceEndpointId);
            }
            TreeSet<String> treeSet = result;
            return treeSet;
        }
        finally {
            this.serviceEndpoints_READ.unlock();
        }
    }

    protected int getServiceEndpointsCount() {
        return this.serviceEndpoints.size();
    }

    public void registerAsMBean(@Nullable MBeanServer mbeanServer, @Nullable String mbeanName) {
        try {
            if (mbeanName == null) {
                mbeanName = String.valueOf(((Package)NullAnalysisHelper.asNonNullUnsafe((Object)this.getClass().getPackage())).getName()) + ":type=" + this.getClass().getSimpleName();
            }
            ObjectName mbeanObjectName = new ObjectName(mbeanName);
            LOG.info("Registering MBean %s", (Object)mbeanName);
            if (mbeanServer == null) {
                mbeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            mbeanServer.registerMBean(this, mbeanObjectName);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    @Override
    public boolean removeService(String serviceEndpointId, Object serviceInstance) throws IllegalArgumentException {
        Args.notNull((String)"serviceEndpointId", (Object)serviceEndpointId);
        Args.notNull((String)"serviceInstance", (Object)serviceInstance);
        this.serviceEndpoints_WRITE.lock();
        try {
            ServiceEndpointState srvConfig = this.serviceEndpoints.get(serviceEndpointId);
            if (srvConfig == null || srvConfig.activeService != serviceInstance) {
                return false;
            }
            srvConfig.removeActiveService();
            this._cleanup();
            return true;
        }
        finally {
            this.serviceEndpoints_WRITE.unlock();
        }
    }

    public final class ServiceEndpointState {
        private final String serviceEndpointId;
        @Nullable Object activeService;
        @Nullable Class<?> activeServiceInterface;
        private final WeakHashSet<ServiceProxyInternal<?>> issuedServiceProxiesWeak = WeakHashSet.create();
        private final HashSet<ServiceProxyInternal<?>> issuedServiceProxiesStrong = new HashSet();

        private ServiceEndpointState(String serviceEndpointId) {
            Args.notNull((String)"serviceEndpointId", (Object)serviceEndpointId);
            this.serviceEndpointId = serviceEndpointId;
        }

        private void checkStrongProxies() {
            Iterator<ServiceProxyInternal<?>> it = this.issuedServiceProxiesStrong.iterator();
            while (it.hasNext()) {
                ServiceProxyInternal<?> serviceProxy = it.next();
                if (serviceProxy.getListenerCount() != 0) continue;
                it.remove();
                this.issuedServiceProxiesWeak.add(serviceProxy);
            }
        }

        private <T> ServiceProxyInternal<T> findOrCreateServiceProxy(Class<T> serviceInterface) {
            ServiceProxyInternal<T> proxy = this.findServiceProxy(serviceInterface);
            if (proxy == null) {
                proxy = DefaultServiceRegistry.this.createServiceProxy(this, serviceInterface);
                this.issuedServiceProxiesWeak.add(proxy);
            }
            return proxy;
        }

        private <T> @Nullable ServiceProxyInternal<T> findServiceProxy(Class<T> serviceInterface) {
            for (ServiceProxyInternal<?> serviceProxyInternal : this.issuedServiceProxiesStrong) {
                if (serviceProxyInternal.getServiceInterface() != serviceInterface) continue;
                return serviceProxyInternal;
            }
            for (ServiceProxyInternal serviceProxyInternal : this.issuedServiceProxiesWeak) {
                if (serviceProxyInternal.getServiceInterface() != serviceInterface) continue;
                return serviceProxyInternal;
            }
            return null;
        }

        public <T> @Nullable T getActiveServiceIfCompatible(Class<T> serviceInterface) {
            if (this.activeService != null && serviceInterface.isAssignableFrom(this.activeService.getClass())) {
                return (T)this.activeService;
            }
            return null;
        }

        public @Nullable Class<?> getActiveServiceInterface() {
            return this.activeServiceInterface;
        }

        public String getServiceEndpointId() {
            return this.serviceEndpointId;
        }

        public void onListenerAdded(ServiceProxyInternal<?> proxy) {
            DefaultServiceRegistry.this.serviceEndpoints_WRITE.lock();
            try {
                this.issuedServiceProxiesWeak.remove(proxy);
                this.issuedServiceProxiesStrong.add(proxy);
            }
            finally {
                DefaultServiceRegistry.this.serviceEndpoints_WRITE.unlock();
            }
        }

        private void removeActiveService() {
            LOG.info("Removing service:\n  serviceEndpointId : %s\n  serviceInterface  : %s [%s]\n  serviceInstance   : %s [%s]", (Object)this.serviceEndpointId, (Object)((Class)NullAnalysisHelper.asNonNullUnsafe(this.activeServiceInterface)).getName(), (Object)this.toString(((Class)NullAnalysisHelper.asNonNullUnsafe(this.activeServiceInterface)).getClassLoader()), (Object)this.toString(this.activeService), (Object)this.toString(NullAnalysisHelper.asNonNullUnsafe((Object)this.activeService).getClass().getClassLoader()));
            this.activeService = null;
            this.activeServiceInterface = null;
            for (ServiceProxyInternal<?> serviceProxyInternal : this.issuedServiceProxiesStrong) {
                serviceProxyInternal.onServiceUnavailable();
            }
            for (ServiceProxyInternal serviceProxyInternal : this.issuedServiceProxiesWeak) {
                serviceProxyInternal.onServiceUnavailable();
            }
        }

        private <SERVICE_INTERFACE> void setActiveService(Class<SERVICE_INTERFACE> serviceInterface, SERVICE_INTERFACE service) {
            LOG.info("Registering service:\n  serviceEndpointId : %s\n  serviceInterface  : %s [%s]\n  serviceInstance   : %s [%s]", (Object)this.serviceEndpointId, (Object)serviceInterface.getName(), (Object)this.toString(serviceInterface.getClassLoader()), (Object)this.toString(service), (Object)this.toString(service.getClass().getClassLoader()));
            this.activeServiceInterface = serviceInterface;
            this.activeService = service;
            this.findOrCreateServiceProxy(serviceInterface);
            for (ServiceProxyInternal<?> serviceProxyInternal : this.issuedServiceProxiesStrong) {
                serviceProxyInternal.onServiceAvailable();
            }
            for (ServiceProxyInternal serviceProxyInternal : this.issuedServiceProxiesWeak) {
                serviceProxyInternal.onServiceAvailable();
            }
        }

        private String toString(@Nullable Object obj) {
            if (obj == null) {
                return "null";
            }
            return String.valueOf(obj.getClass().getName()) + "@" + System.identityHashCode(obj);
        }
    }
}

