/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.serviceregistry.support;

import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.Assert;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.serviceregistry.ServiceRegistry;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SpringBeanAsService<@NonNull T>
implements InitializingBean,
DisposableBean {
    private boolean isInitialized;
    private ServiceRegistry serviceRegistry = (ServiceRegistry)NullAnalysisHelper.lazyNonNull();
    private @Nullable String serviceEndpointId;
    private Class<T> serviceInterface = (Class)NullAnalysisHelper.lazyNonNull();
    private T springBean = NullAnalysisHelper.lazyNonNull();

    public synchronized void afterPropertiesSet() throws Exception {
        Assert.isFalse((boolean)this.isInitialized, (String)"Already initialized!");
        Assert.notNull((Object)this.serviceRegistry, (String)"[serviceRegistry] must not be null!");
        Assert.notNull(this.serviceInterface, (String)"[serviceInterface] must not be null!");
        Assert.notNull(this.springBean, (String)"[service] must not be null!");
        if (this.serviceEndpointId == null) {
            this.serviceEndpointId = this.serviceInterface.getName();
        }
        this.isInitialized = true;
        this.serviceRegistry.addService((String)NullAnalysisHelper.asNonNullUnsafe((Object)this.serviceEndpointId), this.serviceInterface, this.springBean);
    }

    public synchronized void destroy() throws Exception {
        if (!this.isInitialized) {
            return;
        }
        this.serviceRegistry.removeService((String)NullAnalysisHelper.asNonNullUnsafe((Object)this.serviceEndpointId), this.springBean);
        this.isInitialized = false;
    }

    public synchronized void setService(T service) {
        Args.notNull((String)"service", service);
        Assert.isFalse((boolean)this.isInitialized, (String)"Already initialized!");
        this.springBean = service;
    }

    public synchronized void setServiceInterface(Class<T> serviceInterface) {
        Args.notNull((String)"serviceInterface", serviceInterface);
        Assert.isFalse((boolean)this.isInitialized, (String)"Already initialized!");
        Assert.isTrue((boolean)serviceInterface.isInterface(), (String)("[serviceInterface] must be an interface but is " + serviceInterface));
        this.serviceInterface = serviceInterface;
    }

    public synchronized void setServiceRegistry(ServiceRegistry serviceRegistry) {
        Args.notNull((String)"serviceRegistry", (Object)serviceRegistry);
        Assert.isFalse((boolean)this.isInitialized, (String)"Already initialized!");
        this.serviceRegistry = serviceRegistry;
    }
}

