/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jstuff.core.io.IOUtils;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.net.NetUtils;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import org.eclipse.jdt.annotation.Nullable;

public class ClassPathResourcesFilter
implements Filter {
    private static final Logger LOG = Logger.create();
    public static final int DEFAULT_CACHE_TIME_IN_SEC = 86400;
    protected ServletContext ctx = (ServletContext)NullAnalysisHelper.lazyNonNull();
    protected int maxAgeInSeconds;

    public static @Nullable URL findResourceInClassPath(String path) {
        URL resource;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassPathResourcesFilter.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((resource = cl.getResource(path)) == null && path.startsWith("/")) {
            resource = cl.getResource(path.substring(1));
        }
        return resource;
    }

    public ClassPathResourcesFilter() {
        LOG.infoNew((Object)this);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        String resourcePath = req.getServletPath();
        URL resource = this.ctx.getResource(resourcePath);
        if (resource != null) {
            chain.doFilter(request, response);
            return;
        }
        resource = ClassPathResourcesFilter.findResourceInClassPath(resourcePath);
        if (resource == null) {
            chain.doFilter(request, response);
            return;
        }
        long ifModifiedSince = 0L;
        try {
            ifModifiedSince = req.getDateHeader("If-Modified-Since");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        long lastModified = NetUtils.getLastModified((URL)resource);
        long now = System.currentTimeMillis();
        long expires = now + (long)(this.maxAgeInSeconds * 1000);
        HttpServletResponse resp = (HttpServletResponse)response;
        if (ifModifiedSince > 0L && ifModifiedSince <= lastModified) {
            resp.setDateHeader("Expires", expires);
            resp.setStatus(304);
        } else {
            resp.setDateHeader("Date", now);
            resp.setDateHeader("Last-Modified", lastModified);
            resp.setDateHeader("Expires", expires);
            resp.setHeader("Cache-Control", "public");
            resp.addHeader("Cache-Control", "max-age=" + this.maxAgeInSeconds);
            resp.addHeader("Cache-Control", "must-revalidate");
            Throwable throwable = null;
            Object var17_14 = null;
            try (InputStream in = resource.openStream();){
                resp.setHeader("Content-Length", String.valueOf(in.available()));
                IOUtils.copyLarge((InputStream)in, (OutputStream)response.getOutputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public int getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public void init(FilterConfig cfg) throws ServletException {
        this.ctx = cfg.getServletContext();
        this.maxAgeInSeconds = 86400;
        String maxAge = cfg.getInitParameter("max-age-in-seconds");
        if (maxAge != null) {
            this.maxAgeInSeconds = Integer.parseInt(maxAge);
        }
    }

    public void setMaxAgeInSeconds(int maxAgeInSeconds) {
        this.maxAgeInSeconds = maxAgeInSeconds;
    }
}

