/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.jstuff.core.collection.Loops;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.NullAnalysisHelper;

public class RequestAttributeSettingFilter
implements Filter {
    private static final Logger LOG = Logger.create();
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.attributes.isEmpty()) {
            LOG.debug("For request [%s] setting request attributes: %s", (Object)request, this.attributes);
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                request.setAttribute(entry.getKey(), (Object)entry.getValue());
            }
        }
        chain.doFilter(request, response);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Loops.forEach((Enumeration)filterConfig.getInitParameterNames(), param -> this.attributes.put((String)param, (String)NullAnalysisHelper.asNonNullUnsafe((Object)filterConfig.getInitParameter(param))));
    }
}

