/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jstuff.core.validation.Args;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ServletUtils {
    public static <T> T getAttribute(ServletRequest request, String name) {
        return (T)request.getAttribute(name);
    }

    public static @Nullable X509Certificate getClientCertificate(ServletRequest request) {
        Args.notNull((String)"request", (Object)request);
        X509Certificate[] certChain = (X509Certificate[])ServletUtils.getAttribute(request, "javax.servlet.request.X509Certificate");
        if (certChain == null || certChain.length == 0) {
            return null;
        }
        return certChain[0];
    }

    public static String getContextURL(HttpServletRequest request) {
        Args.notNull((String)"request", (Object)request);
        String scheme = request.getScheme();
        int port = request.getServerPort();
        String urlPath = request.getContextPath();
        StringBuilder url = new StringBuilder();
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (port != 80 && "http".equals(scheme) || port != 443 && "https".equals(scheme)) {
            url.append(':');
            url.append(request.getServerPort());
        }
        url.append(urlPath);
        return url.toString();
    }

    public static void requestBasicAuth(HttpServletResponse response, String realm) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
        response.sendError(401);
    }

    public static void setNoCachingHeaders(HttpServletResponse response) {
        Args.notNull((String)"response", (Object)response);
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
    }

    public static void setRecommendedSecurityHeaders(HttpServletResponse response, boolean alwaysHTTPS) {
        Args.notNull((String)"response", (Object)response);
        response.setHeader("X-XSS-Protection", "1");
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("X-Frame-Options", "SAMEORIGIN");
        if (alwaysHTTPS) {
            response.setHeader("Strict-Transport-Security", "max-age=63072000; includeSubDomains");
        }
        response.setHeader("Referrer-Policy", "no-referrer");
    }
}

