/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet.session;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.sf.jstuff.core.logging.Logger;

public class CountingHttpSessionListener
implements HttpSessionListener {
    private static final Logger LOG = Logger.create();
    private static final HttpSessionBindingListenerImpl LISTENER = new HttpSessionBindingListenerImpl();
    private static final AtomicInteger SESSION_COUNT = new AtomicInteger();

    public static int getSessionCount() {
        return SESSION_COUNT.intValue();
    }

    public CountingHttpSessionListener() {
        LOG.infoNew((Object)this);
    }

    public void sessionCreated(HttpSessionEvent se) {
        SESSION_COUNT.incrementAndGet();
        se.getSession().setAttribute(CountingHttpSessionListener.class.getName(), (Object)LISTENER);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
    }

    private static final class HttpSessionBindingListenerImpl
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private HttpSessionBindingListenerImpl() {
        }

        public void valueBound(HttpSessionBindingEvent ev) {
        }

        public void valueUnbound(HttpSessionBindingEvent ev) {
            SESSION_COUNT.decrementAndGet();
        }
    }
}

