/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.spring;

import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import net.sf.jstuff.core.collection.ArrayUtils;
import net.sf.jstuff.core.logging.Logger;
import org.springframework.aop.support.AopUtils;

public abstract class SpringBeanParanamer {
    private static final Logger LOG = Logger.create();
    private static final Paranamer PARANAMER = new CachingParanamer((Paranamer)new BytecodeReadingParanamer());

    public static String[] getParameterNames(Method beanMethod, Object bean) {
        if (beanMethod.getParameterTypes().length == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] parameters = null;
        try {
            parameters = PARANAMER.lookupParameterNames((AccessibleObject)beanMethod);
        }
        catch (ParameterNamesNotFoundException parameterNamesNotFoundException) {}
        if (parameters != null && beanMethod.getParameterTypes().length == parameters.length) {
            return parameters;
        }
        try {
            Method serviceImplMethod = AopUtils.getTargetClass((Object)bean).getMethod(beanMethod.getName(), beanMethod.getParameterTypes());
            parameters = PARANAMER.lookupParameterNames((AccessibleObject)serviceImplMethod);
            if (parameters != null) {
                return parameters;
            }
        }
        catch (Exception ex) {
            LOG.trace("Unexpected exception", (Object)ex);
        }
        String[] names = new String[beanMethod.getParameterTypes().length];
        int i = 0;
        int l = beanMethod.getParameterTypes().length;
        while (i < l) {
            names[i] = "param" + i;
            ++i;
        }
        return names;
    }
}

