/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.spring;

import java.io.Serializable;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.spring.SpringBeanLocator;
import org.eclipse.jdt.annotation.Nullable;

public final class SpringBeanRef<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final @Nullable String beanName;
    private final @Nullable Class<T> beanType;
    private transient @Nullable T springBean;

    public static <T> SpringBeanRef<T> of(Class<T> beanType) {
        return new SpringBeanRef<T>(beanType);
    }

    public static <T> SpringBeanRef<T> of(String beanName) {
        return new SpringBeanRef<T>(beanName);
    }

    private SpringBeanRef(Class<T> beanType) {
        Args.notNull((String)"beanType", beanType);
        this.beanType = beanType;
        this.beanName = null;
    }

    private SpringBeanRef(String beanName) {
        Args.notNull((String)"beanName", (Object)beanName);
        this.beanName = beanName;
        this.beanType = null;
    }

    public T get() {
        if (this.springBean == null) {
            this.springBean = this.beanName == null ? SpringBeanLocator.get().byClass((Class)NullAnalysisHelper.asNonNullUnsafe(this.beanType)) : SpringBeanLocator.get().byName((String)NullAnalysisHelper.asNonNullUnsafe((Object)this.beanName));
        }
        return (T)NullAnalysisHelper.asNonNullUnsafe(this.springBean);
    }
}

