/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.spring.convert;

import net.sf.jstuff.core.validation.Args;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;

public abstract class AbstractConverter
implements ConditionalGenericConverter {
    @Autowired
    protected ConversionService conversionService;

    protected AbstractConverter() {
    }

    protected AbstractConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Args.notNull((String)"targetType", (Object)targetType);
        if (!this.conversionService.canConvert(sourceType, targetType.getMapKeyTypeDescriptor())) {
            return false;
        }
        boolean matches = this.conversionService.canConvert(sourceType, targetType.getMapValueTypeDescriptor());
        return matches;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

