/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.userregistry.ldap;

import javax.inject.Inject;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.ldap.LdapTemplate;
import net.sf.jstuff.integration.ldap.LdapUtils;
import net.sf.jstuff.integration.userregistry.DefaultUserDetails;
import net.sf.jstuff.integration.userregistry.UserDetails;
import net.sf.jstuff.integration.userregistry.UserDetailsService;
import org.eclipse.jdt.annotation.Nullable;

public class LdapUserDetailsService
implements UserDetailsService {
    private static final Logger LOG = Logger.create();
    protected LdapTemplate ldapTemplate = (LdapTemplate)NullAnalysisHelper.lazyNonNull();
    protected String userAttributeDisplayName = (String)NullAnalysisHelper.lazyNonNull();
    protected String userAttributeEMailAdress = (String)NullAnalysisHelper.lazyNonNull();
    protected String userAttributeLogonName = (String)NullAnalysisHelper.lazyNonNull();
    protected String userAttributeUserId = (String)NullAnalysisHelper.lazyNonNull();
    protected String userSearchBase = (String)NullAnalysisHelper.lazyNonNull();
    protected String userSearchFilter = (String)NullAnalysisHelper.lazyNonNull();
    protected boolean userSearchSubtree = true;

    public LdapUserDetailsService() {
        LOG.infoNew((Object)this);
    }

    public String getUserAttributeLogonName() {
        return this.userAttributeLogonName;
    }

    protected @Nullable UserDetails getUserDetailsByFilter(String filter) {
        Args.notNull((String)"filter", (Object)filter);
        return (UserDetails)this.ldapTemplate.execute(ctx -> {
            NamingEnumeration<SearchResult> results = this.searchUser((DirContext)ctx, filter, new String[]{this.userAttributeDisplayName, this.userAttributeEMailAdress, this.userAttributeLogonName, this.userAttributeUserId});
            if (!results.hasMore()) {
                return null;
            }
            SearchResult sr = results.next();
            Attributes attr = sr.getAttributes();
            NameParser parser = ctx.getNameParser("");
            Name contextName = parser.parse(ctx.getNameInNamespace());
            Name baseName = parser.parse(this.userSearchBase);
            Name entryName = parser.parse(new CompositeName(sr.getName()).get(0));
            Name dn = contextName.addAll(baseName).addAll(entryName);
            return new DefaultUserDetails(LdapUtils.getAttributeValue(attr, this.userAttributeUserId, "n/a"), LdapUtils.getAttributeValue(attr, this.userAttributeDisplayName, "n/a"), LdapUtils.getAttributeValue(attr, this.userAttributeLogonName, null), dn.toString(), LdapUtils.getAttributeValue(attr, this.userAttributeEMailAdress, null));
        });
    }

    @Override
    public @Nullable UserDetails getUserDetailsByLogonName(String logonName) {
        Args.notNull((String)"logonName", (Object)logonName);
        return this.getUserDetailsByFilter(String.valueOf(this.userAttributeLogonName) + "=" + LdapUtils.ldapEscape(logonName));
    }

    @Override
    public @Nullable UserDetails getUserDetailsByUserId(String userId) {
        Args.notNull((String)"userId", (Object)userId);
        return this.getUserDetailsByFilter(String.valueOf(this.userAttributeUserId) + "=" + LdapUtils.ldapEscape(userId));
    }

    protected NamingEnumeration<SearchResult> searchUser(DirContext ctx, String filter, String[] attrs) throws NamingException {
        SearchControls options = new SearchControls();
        options.setSearchScope(this.userSearchSubtree ? 2 : 1);
        options.setReturningAttributes(attrs);
        return ctx.search(this.userSearchBase, "(&(" + filter + ")(" + this.userSearchFilter + "))", options);
    }

    @Inject
    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        Args.notNull((String)"ldapTemplate", (Object)ldapTemplate);
        this.ldapTemplate = ldapTemplate;
    }

    @Inject
    public void setUserAttributeDisplayName(String userAttributeDisplayName) {
        Args.notNull((String)"userAttributeDisplayName", (Object)userAttributeDisplayName);
        this.userAttributeDisplayName = userAttributeDisplayName;
    }

    @Inject
    public void setUserAttributeEMailAdress(String userAttributeEMailAdress) {
        Args.notNull((String)"userAttributeEMailAdress", (Object)userAttributeEMailAdress);
        this.userAttributeEMailAdress = userAttributeEMailAdress;
    }

    @Inject
    public void setUserAttributeLogonName(String userAttributeLogonName) {
        Args.notNull((String)"userAttributeLogonName", (Object)userAttributeLogonName);
        this.userAttributeLogonName = userAttributeLogonName;
    }

    @Inject
    public void setUserAttributeUserId(String userAttributeUserId) {
        Args.notNull((String)"userAttributeUserId", (Object)userAttributeUserId);
        this.userAttributeUserId = userAttributeUserId;
    }

    @Inject
    public void setUserSearchBase(String userSearchBase) {
        Args.notNull((String)"userSearchBase", (Object)userSearchBase);
        this.userSearchBase = userSearchBase;
    }

    @Inject
    public void setUserSearchFilter(String userSearchFilter) {
        Args.notNull((String)"userSearchFilter", (Object)userSearchFilter);
        this.userSearchFilter = userSearchFilter;
    }

    public void setUserSearchSubtree(boolean userSearchSubtree) {
        this.userSearchSubtree = userSearchSubtree;
    }
}

