/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

public final class YamlNode
extends ObjectNode {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.INDENT_ARRAYS).disable(YAMLGenerator.Feature.SPLIT_LINES).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
    private static final long serialVersionUID = 1L;

    public static YamlNode create() {
        return new YamlNode(OBJECT_MAPPER.getNodeFactory());
    }

    private YamlNode(JsonNodeFactory nc) {
        super(nc);
    }

    public YamlNode compute(Consumer<YamlNode> consumer) {
        consumer.accept(this);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable BigDecimal v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable BigInteger v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, boolean v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable Boolean v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, byte @Nullable [] v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable JsonNode value) {
        this.set(fieldName, value);
        return this;
    }

    public YamlNode put(String fieldName, double v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable Double v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, float v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable Float v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, int v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable Integer v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, long v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable Long v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable Object obj) {
        super.set(fieldName, obj == null ? null : OBJECT_MAPPER.valueToTree(obj));
        return this;
    }

    public YamlNode put(String fieldName, short v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable Short v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode put(String fieldName, @Nullable String v) {
        super.put(fieldName, v);
        return this;
    }

    public YamlNode putNull(String fieldName) {
        super.putNull(fieldName);
        return this;
    }

    public YamlNode putPOJO(String fieldName, @Nullable Object pojo) {
        super.putPOJO(fieldName, pojo);
        return this;
    }

    public YamlNode putRawValue(String fieldName, @Nullable RawValue raw) {
        super.putRawValue(fieldName, raw);
        return this;
    }

    public YamlNode remove(Collection<String> fieldNames) {
        super.remove(fieldNames);
        return this;
    }

    public @Nullable JsonNode remove(@Nullable String fieldName) {
        JsonNode removedValue = super.remove(fieldName);
        return removedValue;
    }

    public YamlNode removeAll() {
        super.removeAll();
        return this;
    }

    public JsonNode replace(String fieldName, @Nullable JsonNode value) {
        JsonNode replacedValue = super.replace(fieldName, value);
        return replacedValue;
    }

    public YamlNode retain(Collection<String> fieldNames) {
        super.retain(fieldNames);
        return this;
    }

    public YamlNode retain(String ... fieldNames) {
        super.retain(fieldNames);
        return this;
    }

    public YamlNode set(String fieldName, @Nullable JsonNode value) {
        super.set(fieldName, value);
        return this;
    }

    public <T extends JsonNode> T setAll(Map<String, ? extends JsonNode> properties) {
        super.setAll(properties);
        return (T)((Object)this);
    }

    public YamlNode setAll(ObjectNode other) {
        super.setAll(other);
        return this;
    }

    public String toPrettyString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException ex) {
            return String.valueOf(((Object)((Object)ex)).getClass().getSimpleName()) + ": " + ex.getMessage();
        }
    }

    public String toString() {
        return this.toPrettyString();
    }

    public <T extends JsonNode> T without(Collection<String> fieldNames) {
        super.without(fieldNames);
        return (T)((Object)this);
    }

    public YamlNode without(String fieldName) {
        super.without(fieldName);
        return this;
    }
}

