/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbdiff.DBDiffPluginResources;
import net.sourceforge.squirrel_sql.plugins.dbdiff.DBDiffPluginSessionCallback;
import net.sourceforge.squirrel_sql.plugins.dbdiff.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbdiff.actions.CompareAction;
import net.sourceforge.squirrel_sql.plugins.dbdiff.actions.SelectAction;

public class DBDiffPlugin
extends DefaultSessionPlugin
implements SessionInfoProvider {
    private static final ILogger s_log = LoggerController.createLogger(DBDiffPlugin.class);
    private PluginResources _resources;
    private ISession diffSourceSession = null;
    private ISession diffDestSession = null;
    private IDatabaseObjectInfo[] selectedDatabaseObjects = null;
    private IDatabaseObjectInfo[] selectedDestDatabaseObjects = null;
    public static final String BUNDLE_BASE_NAME = "net.sourceforge.squirrel_sql.plugins.dbdiff.dbdiff";

    public PluginSessionCallback sessionStarted(ISession session) {
        this.addMenuItemsToContextMenu(session);
        return new DBDiffPluginSessionCallback(this);
    }

    public String getInternalName() {
        return "dbdiff";
    }

    public String getDescriptiveName() {
        return "DBDiff Plugin";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "";
    }

    public String getVersion() {
        return "0.01";
    }

    public String getHelpFileName() {
        return "readme.html";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public void initialize() throws PluginException {
        super.initialize();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Initializing DB Diff Plugin");
        }
        this._resources = new DBDiffPluginResources(BUNDLE_BASE_NAME, (IPlugin)this);
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new SelectAction(app, (Resources)this._resources, this)));
        coll.add((Action)((Object)new CompareAction(app, (Resources)this._resources, this)));
    }

    public void unload() {
        super.unload();
    }

    public void setSelectedDatabaseObjects(IDatabaseObjectInfo[] dbObjArr) {
        if (dbObjArr != null) {
            this.selectedDatabaseObjects = dbObjArr;
            for (int i = 0; i < dbObjArr.length; ++i) {
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("setSelectedDatabaseObjects: IDatabaseObjectInfo[" + i + "]=" + dbObjArr[i]));
            }
        }
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return new IGlobalPreferencesPanel[0];
    }

    protected void addMenuItemsToContextMenu(ISession session) {
        final IObjectTreeAPI api = session.getObjectTreeAPIOfActiveSessionWindow();
        final ActionCollection coll = this.getApplication().getActionCollection();
        if (SwingUtilities.isEventDispatchThread()) {
            this.addToPopup(api, coll);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBDiffPlugin.this.addToPopup(api, coll);
                }
            });
        }
    }

    private void addToPopup(IObjectTreeAPI api, ActionCollection coll) {
        JMenu dbdiffMenu = this._resources.createMenu("dbdiff");
        JMenuItem selectItem = new JMenuItem(coll.get(SelectAction.class));
        JMenuItem compareItem = new JMenuItem(coll.get(CompareAction.class));
        dbdiffMenu.add(selectItem);
        dbdiffMenu.add(compareItem);
        api.addToPopup(DatabaseObjectType.CATALOG, dbdiffMenu);
        api.addToPopup(DatabaseObjectType.SCHEMA, dbdiffMenu);
        api.addToPopup(DatabaseObjectType.TABLE_TYPE_DBO, dbdiffMenu);
        api.addToPopup(DatabaseObjectType.TABLE, dbdiffMenu);
    }

    public void setCompareMenuEnabled(boolean enabled) {
        ActionCollection coll = this.getApplication().getActionCollection();
        CompareAction compareAction = (CompareAction)((Object)coll.get(CompareAction.class));
        compareAction.setEnabled(enabled);
    }

    @Override
    public ISession getDiffSourceSession() {
        return this.diffSourceSession;
    }

    @Override
    public void setDiffSourceSession(ISession session) {
        if (session != null) {
            this.diffSourceSession = session;
        }
    }

    @Override
    public IDatabaseObjectInfo[] getSourceSelectedDatabaseObjects() {
        return this.selectedDatabaseObjects;
    }

    @Override
    public ISession getDiffDestSession() {
        return this.diffDestSession;
    }

    @Override
    public void setDestDiffSession(ISession session) {
        this.diffDestSession = session;
    }

    @Override
    public IDatabaseObjectInfo[] getDestSelectedDatabaseObjects() {
        return this.selectedDestDatabaseObjects;
    }

    @Override
    public void setDestSelectedDatabaseObjects(IDatabaseObjectInfo[] info) {
        this.selectedDestDatabaseObjects = info;
    }
}

