/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff.actions;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbdiff.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbdiff.commands.CompareCommand;

public class CompareAction
extends SquirrelAction
implements ISessionAction {
    private static final long serialVersionUID = 1L;
    private final SessionInfoProvider sessionInfoProv;
    private static final ILogger log = LoggerController.createLogger(CompareAction.class);

    public CompareAction(IApplication app, Resources rsrc, SessionInfoProvider prov) {
        super(app, rsrc);
        this.sessionInfoProv = prov;
    }

    public void actionPerformed(ActionEvent evt) {
        ISession destSession = this.sessionInfoProv.getDiffDestSession();
        IObjectTreeAPI api = destSession.getObjectTreeAPIOfActiveSessionWindow();
        if (api == null) {
            return;
        }
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        this.sessionInfoProv.setDestSelectedDatabaseObjects(dbObjs);
        if (this.sessionInfoProv.getDiffSourceSession() == null) {
            return;
        }
        if (!this.sourceDestSchemasDiffer()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Source and destination schemas were the same schema");
            }
            return;
        }
        new CompareCommand(this.sessionInfoProv).execute();
    }

    public void setSession(ISession session) {
        this.sessionInfoProv.setDestDiffSession(session);
    }

    private boolean sourceDestSchemasDiffer() {
        ISession sourceSession = this.sessionInfoProv.getDiffSourceSession();
        ISession destSession = this.sessionInfoProv.getDiffDestSession();
        return sourceSession != null && !sourceSession.equals(destSession);
    }
}

