/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfo;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbdiff.SessionInfoProvider;
import org.hibernate.MappingException;

public class DBUtil {
    private static final ILogger log = LoggerController.createLogger(DBUtil.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DBUtil.class);
    private static String lastStatement = null;
    private static String lastStatementValues = null;

    public static String getPKColumnString(ISQLConnection sourceConn, ITableInfo ti) throws SQLException {
        List<String> pkColumns = DBUtil.getPKColumnList(sourceConn, ti);
        if (pkColumns == null || pkColumns.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("(");
        Iterator<String> i = pkColumns.iterator();
        while (i.hasNext()) {
            String columnName = i.next();
            sb.append(columnName);
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static List<String> getPKColumnList(ISQLConnection sourceConn, ITableInfo ti) throws SQLException {
        ArrayList<String> pkColumns = new ArrayList<String>();
        DatabaseMetaData md = sourceConn.getConnection().getMetaData();
        ResultSet rs = null;
        rs = md.supportsCatalogsInTableDefinitions() ? md.getPrimaryKeys(ti.getCatalogName(), null, ti.getSimpleName()) : (md.supportsSchemasInTableDefinitions() ? md.getPrimaryKeys(null, ti.getSchemaName(), ti.getSimpleName()) : md.getPrimaryKeys(null, null, ti.getSimpleName()));
        while (rs.next()) {
            String keyColumn = rs.getString(4);
            if (keyColumn == null) continue;
            pkColumns.add(keyColumn);
        }
        if (pkColumns.size() == 0) {
            return null;
        }
        return pkColumns;
    }

    public static boolean tableHasForeignKey(String destCatalog, String destSchema, String destTableName, ForeignKeyInfo fkInfo, SessionInfoProvider prov) {
        boolean result;
        block4: {
            result = false;
            try {
                SQLDatabaseMetaData md = prov.getDiffDestSession().getSQLConnection().getSQLMetaData();
                ITableInfo[] tables = md.getTables(destCatalog, destSchema, destTableName, new String[]{"TABLE"}, null);
                if (tables != null && tables.length == 1) {
                    ForeignKeyInfo[] fks;
                    for (ForeignKeyInfo existingKey : fks = SQLUtilities.getImportedKeys((ITableInfo)tables[0], (SQLDatabaseMetaData)md)) {
                        if (!DBUtil.areEqual(existingKey, fkInfo)) continue;
                        result = true;
                        break block4;
                    }
                    break block4;
                }
                log.error((Object)("Couldn't find an exact match for destination table " + destTableName + " in schema " + destSchema + " and catalog " + destCatalog + ". Skipping FK constraint"));
            }
            catch (SQLException e) {
                log.error((Object)("Unexpected exception while attempting to determine if a table (" + destTableName + ") has a particular foreign " + "key"));
            }
        }
        return result;
    }

    private static boolean areEqual(ForeignKeyInfo fk1, ForeignKeyInfo fk2) {
        String fk1FKColumn = fk1.getForeignKeyColumnName();
        String fk2FKColumn = fk2.getForeignKeyColumnName();
        String fk1PKColumn = fk1.getPrimaryKeyColumnName();
        String fk2PKColumn = fk2.getPrimaryKeyColumnName();
        String fk1FKTable = fk1.getForeignKeyTableName();
        String fk2FKTable = fk2.getForeignKeyTableName();
        String fk1PKTable = fk1.getPrimaryKeyTableName();
        String fk2PKTable = fk2.getPrimaryKeyTableName();
        if (!fk1PKColumn.equals(fk2PKColumn)) {
            return false;
        }
        if (!fk1FKColumn.equals(fk2FKColumn)) {
            return false;
        }
        if (!fk1PKTable.equals(fk2PKTable)) {
            return false;
        }
        return fk1FKTable.equals(fk2FKTable);
    }

    public static boolean containsTable(List<ITableInfo> tableInfos, String table) {
        boolean result = false;
        for (ITableInfo ti : tableInfos) {
            if (!table.equalsIgnoreCase(ti.getSimpleName())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static ResultSet executeQuery(ISession session, String sql) throws SQLException {
        ISQLConnection sqlcon = session.getSQLConnection();
        if (sqlcon == null || sql == null) {
            return null;
        }
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = sqlcon.getConnection();
        try {
            stmt = con.createStatement();
        }
        catch (SQLException e) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            throw e;
        }
        if (log.isDebugEnabled()) {
            String msg = s_stringMgr.getString("DBUtil.info.executequery", new Object[]{sql});
            log.debug((Object)msg);
        }
        try {
            lastStatement = sql;
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            throw e;
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int getTableCount(ISession session, String tableName) {
        ResultSet rs;
        int result;
        block4: {
            result = -1;
            rs = null;
            try {
                String sql = "select count(*) from " + tableName;
                rs = DBUtil.executeQuery(session, sql);
                if (!rs.next()) break block4;
                result = rs.getInt(1);
            }
            catch (Exception e) {
                SQLUtilities.closeResultSet(rs);
                catch (Throwable throwable) {
                    SQLUtilities.closeResultSet(rs);
                    throw throwable;
                }
            }
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        return result;
    }

    public static int getTableCount(ISession session, String catalog, String schema, String tableName, int sessionType) throws UserCancelledOperationException {
        String table = DBUtil.getQualifiedObjectName(session, catalog, schema, tableName, sessionType);
        return DBUtil.getTableCount(session, table);
    }

    public static ITableInfo getTableInfo(ISession session, String schema, String tableName) throws SQLException, MappingException, UserCancelledOperationException {
        ITableInfo[] tis;
        ISQLConnection con = session.getSQLConnection();
        SchemaInfo schemaInfo = session.getSchemaInfo();
        if (con.getSQLMetaData().getDriverName().toLowerCase().startsWith("axion")) {
            schema = "";
        }
        String catalog = null;
        if (DialectFactory.isMySQL((ISQLDatabaseMetaData)session.getMetaData())) {
            catalog = schema;
            schema = null;
        }
        if (((tis = schemaInfo.getITableInfos(catalog, schema, tableName = tableName.trim())) == null || tis.length == 0) && (tis = schemaInfo.getITableInfos(null, schema, tableName = Character.isUpperCase(tableName.charAt(0)) ? tableName.toLowerCase() : tableName.toUpperCase())).length == 0) {
            tableName = Character.isUpperCase(tableName.charAt(0)) ? tableName.toLowerCase() : tableName.toUpperCase();
            tis = schemaInfo.getITableInfos(null, schema, tableName);
        }
        if (tis.length == 0) {
            String msg = s_stringMgr.getString("DBUtil.error.tablenotfound", new String[]{tableName, schema});
            throw new MappingException(msg);
        }
        if (tis.length > 1 && log.isDebugEnabled()) {
            log.debug((Object)("DBUtil.getTableInfo: found " + tis.length + " that matched " + "catalog=" + catalog + " schema=" + schema + " tableName=" + tableName));
        }
        return tis[0];
    }

    public static int replaceOtherDataType(TableColumnInfo colInfo) throws MappingException {
        int colJdbcType = colInfo.getDataType();
        if (colJdbcType == 1111) {
            String typeName = colInfo.getTypeName().toUpperCase();
            int parenIndex = typeName.indexOf("(");
            if (parenIndex != -1) {
                typeName = typeName.substring(0, parenIndex);
            }
            if ((colJdbcType = JDBCTypeMapper.getJdbcType((String)typeName)) == 0) {
                throw new MappingException("Encoutered jdbc type OTHER (1111) and couldn't map the database-specific type name (" + typeName + ") to a jdbc type");
            }
        }
        return colJdbcType;
    }

    public static int getColumnType(ISQLConnection con, ITableInfo ti, String columnName) throws SQLException {
        int result = -1;
        if (ti != null) {
            TableColumnInfo[] tciArr = con.getSQLMetaData().getColumnInfo(ti);
            for (int i = 0; i < tciArr.length; ++i) {
                if (!tciArr[i].getColumnName().equalsIgnoreCase(columnName)) continue;
                result = tciArr[i].getDataType();
                break;
            }
        }
        return result;
    }

    public static int[] getColumnTypes(ISQLConnection con, ITableInfo ti, String[] colNames) throws SQLException {
        TableColumnInfo[] tciArr = con.getSQLMetaData().getColumnInfo(ti);
        int[] result = new int[tciArr.length];
        for (int i = 0; i < tciArr.length; ++i) {
            boolean found = false;
            for (int j = 0; j < colNames.length && !found; ++j) {
                String columnName = colNames[j];
                if (!tciArr[i].getColumnName().equalsIgnoreCase(columnName)) continue;
                result[i] = tciArr[i].getDataType();
                found = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableHasPrimaryKey(ISQLConnection con, ITableInfo ti) throws SQLException {
        boolean result = false;
        ResultSet rs = null;
        try {
            DatabaseMetaData md = con.getConnection().getMetaData();
            String cat = ti.getCatalogName();
            String schema = ti.getSchemaName();
            String tableName = ti.getSimpleName();
            rs = md.getPrimaryKeys(cat, schema, tableName);
            if (rs.next()) {
                result = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        return result;
    }

    public static String getColumnList(TableColumnInfo[] colInfoArr) throws SQLException {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < colInfoArr.length; ++i) {
            TableColumnInfo colInfo = colInfoArr[i];
            String columnName = colInfo.getColumnName();
            result.append(columnName);
            if (i >= colInfoArr.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String getColumnName(ISQLConnection sourceConn, ITableInfo ti, int column) throws SQLException {
        TableColumnInfo[] infoArr = sourceConn.getSQLMetaData().getColumnInfo(ti);
        TableColumnInfo colInfo = infoArr[column];
        return colInfo.getColumnName();
    }

    public static String[] getColumnNames(ISQLConnection sourceConn, ITableInfo ti) throws SQLException {
        TableColumnInfo[] infoArr = sourceConn.getSQLMetaData().getColumnInfo(ti);
        String[] result = new String[infoArr.length];
        for (int i = 0; i < result.length; ++i) {
            TableColumnInfo colInfo = infoArr[i];
            result[i] = colInfo.getColumnName();
        }
        return result;
    }

    public static String getSelectQuery(SessionInfoProvider prov, String columnList, ITableInfo ti) throws SQLException, UserCancelledOperationException {
        StringBuilder result = new StringBuilder("select ");
        result.append(columnList);
        result.append(" from ");
        ISession sourceSession = prov.getDiffSourceSession();
        String tableName = DBUtil.getQualifiedObjectName(sourceSession, ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), 0);
        result.append(tableName);
        return result.toString();
    }

    public static boolean isBinaryType(TableColumnInfo columnInfo) {
        boolean result = false;
        int type = columnInfo.getDataType();
        if (type == -2 || type == 2004 || type == -4 || type == -3) {
            result = true;
        }
        return result;
    }

    public static String getQualifiedObjectName(ISession session, String catalogName, String schemaName, String objectName, int sessionType) throws UserCancelledOperationException {
        String catalog = DBUtil.fixCase(session, catalogName);
        String schema = DBUtil.fixCase(session, schemaName);
        String object = DBUtil.fixCase(session, objectName);
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        boolean useSchema = true;
        boolean useCatalog = true;
        try {
            useCatalog = md.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException e) {
            log.info((Object)"Encountered unexpected exception while attempting to determine if catalogs are used in table definitions");
        }
        try {
            useSchema = md.supportsSchemasInTableDefinitions();
        }
        catch (SQLException e) {
            log.info((Object)"Encountered unexpected exception while attempting to determine if schemas are used in table definitions");
        }
        if (!useCatalog && !useSchema) {
            return object;
        }
        if ((catalog == null || catalog.equals("")) && (schema == null || schema.equals(""))) {
            return object;
        }
        StringBuilder result = new StringBuilder();
        if (useCatalog && catalog != null && !catalog.equals("")) {
            result.append(catalog);
            result.append(DBUtil.getCatSep(session));
        }
        if (useSchema && schema != null && !schema.equals("")) {
            result.append(schema);
            result.append(".");
        }
        result.append(object);
        return result.toString();
    }

    public static String getCatSep(ISession session) {
        String catsep = ".";
        try {
            SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
            catsep = md.getCatalogSeparator();
        }
        catch (SQLException e) {
            log.error((Object)("getCatSep: Unexpected Exception - " + e.getMessage()), (Throwable)e);
        }
        return catsep;
    }

    public static String fixCase(ISession session, String identifier) {
        if (identifier == null || identifier.equals("")) {
            return identifier;
        }
        try {
            DatabaseMetaData md = session.getSQLConnection().getConnection().getMetaData();
            if (md.storesMixedCaseIdentifiers()) {
                return identifier;
            }
            if (md.storesUpperCaseIdentifiers()) {
                return identifier.toUpperCase();
            }
            return identifier.toLowerCase();
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fixCase: unexpected exception: " + e.getMessage()));
            }
            return identifier;
        }
    }

    public static int getColumnCount(ISQLConnection sourceConn, ITableInfo ti) throws SQLException {
        return sourceConn.getSQLMetaData().getColumnInfo(ti).length;
    }

    public static int getColumnType(ISQLConnection con, ITableInfo ti, int column) throws SQLException {
        TableColumnInfo[] infoArr = con.getSQLMetaData().getColumnInfo(ti);
        TableColumnInfo colInfo = infoArr[column];
        return colInfo.getDataType();
    }

    public static int[] getColumnTypes(ISQLConnection con, ITableInfo ti) throws SQLException {
        TableColumnInfo[] infoArr = con.getSQLMetaData().getColumnInfo(ti);
        int[] result = new int[infoArr.length];
        for (int i = 0; i < result.length; ++i) {
            TableColumnInfo colInfo = infoArr[i];
            result[i] = colInfo.getDataType();
        }
        return result;
    }

    public static boolean sameDatabaseType(ISession session1, ISession session2) {
        String driver2ClassName;
        boolean result = false;
        String driver1ClassName = session1.getDriver().getDriverClassName();
        if (driver1ClassName.equals(driver2ClassName = session2.getDriver().getDriverClassName())) {
            result = true;
        }
        return result;
    }

    public static String getMaxColumnLengthSQL(ISession sourceSession, TableColumnInfo colInfo, String tableName, boolean tableNameIsQualified) throws UserCancelledOperationException {
        String maxFunction;
        StringBuilder result = new StringBuilder();
        HibernateDialect dialect = DialectFactory.getDialect((int)0, (JFrame)sourceSession.getApplication().getMainFrame(), (ISQLDatabaseMetaData)sourceSession.getMetaData());
        String lengthFunction = dialect.getLengthFunction(colInfo.getDataType());
        if (lengthFunction == null) {
            log.error((Object)("Length function is null for dialect=" + dialect.getClass().getName() + ". Using 'length'"));
            lengthFunction = "length";
        }
        if ((maxFunction = dialect.getMaxFunction()) == null) {
            log.error((Object)("Max function is null for dialect=" + dialect.getClass().getName() + ". Using 'max'"));
            maxFunction = "max";
        }
        result.append("select ");
        result.append(maxFunction);
        result.append("(");
        result.append(lengthFunction);
        result.append("(");
        result.append(colInfo.getColumnName());
        result.append(")) from ");
        String table = tableName;
        if (!tableNameIsQualified) {
            table = DBUtil.getQualifiedObjectName(sourceSession, colInfo.getCatalogName(), colInfo.getSchemaName(), tableName, 0);
        }
        result.append(table);
        return result.toString();
    }

    public static void setLastStatement(String lastStatement) {
        DBUtil.lastStatement = lastStatement;
    }

    public static String getLastStatement() {
        return lastStatement;
    }

    public static void setLastStatementValues(String values) {
        lastStatementValues = values;
    }

    public static String getLastStatementValues() {
        return lastStatementValues;
    }
}

