/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff;

import java.awt.Component;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbdiff.ColumnDifference;
import net.sourceforge.squirrel_sql.plugins.dbdiff.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbdiff.TableDiffExecutor;
import net.sourceforge.squirrel_sql.plugins.dbdiff.gui.ColumnDiffDialog;
import net.sourceforge.squirrel_sql.plugins.dbdiff.util.DBUtil;

public class DiffExecutor {
    private static final ILogger s_log = LoggerController.createLogger(DiffExecutor.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DiffExecutor.class);
    SessionInfoProvider prov = null;
    ISession sourceSession = null;
    ISession destSession = null;
    private Thread execThread = null;
    private List<ColumnDifference> colDifferences = new ArrayList<ColumnDifference>();

    public DiffExecutor(SessionInfoProvider p) {
        this.prov = p;
        this.sourceSession = this.prov.getDiffSourceSession();
        this.destSession = this.prov.getDiffDestSession();
    }

    public void execute() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DiffExecutor.this._execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.execThread = new Thread(runnable);
        this.execThread.setName("DBDiff Executor Thread");
        this.execThread.start();
    }

    private void _execute() throws SQLException {
        IDatabaseObjectInfo[] destObjs;
        boolean encounteredException = false;
        IDatabaseObjectInfo[] sourceObjs = this.prov.getSourceSelectedDatabaseObjects();
        if (!this.sanityCheck(sourceObjs, destObjs = this.prov.getDestSelectedDatabaseObjects())) {
            return;
        }
        ISQLDatabaseMetaData sourceMetaData = this.prov.getDiffSourceSession().getMetaData();
        ISQLDatabaseMetaData destMetaData = this.prov.getDiffDestSession().getMetaData();
        Map<String, ITableInfo> tableMap1 = this.getTableMap(sourceMetaData, sourceObjs);
        Map<String, ITableInfo> tableMap2 = this.getTableMap(destMetaData, destObjs);
        Set<String> tableNames = this.getAllTableNames(tableMap1);
        tableNames.addAll(this.getAllTableNames(tableMap2));
        try {
            TableDiffExecutor diff = new TableDiffExecutor(sourceMetaData, destMetaData);
            for (String table : tableNames) {
                if (!tableMap1.containsKey(table) || !tableMap2.containsKey(table)) continue;
                ITableInfo t1 = tableMap1.get(table);
                ITableInfo t2 = tableMap2.get(table);
                diff.setTableInfos(t1, t2);
                diff.execute();
                List<ColumnDifference> columnDiffs = diff.getColumnDifferences();
                if (columnDiffs == null || columnDiffs.size() <= 0) continue;
                this.colDifferences.addAll(columnDiffs);
                for (ColumnDifference colDiff : columnDiffs) {
                    System.out.println(colDiff.toString());
                }
            }
            final MainFrame frame = this.sourceSession.getApplication().getMainFrame();
            if (this.colDifferences != null && this.colDifferences.size() > 0) {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ColumnDiffDialog dialog = new ColumnDiffDialog((Frame)frame, false);
                        dialog.setColumnDifferences(DiffExecutor.this.colDifferences);
                        dialog.setSession1Label(DiffExecutor.this.sourceSession.getAlias().getName());
                        dialog.setSession2Label(DiffExecutor.this.destSession.getAlias().getName());
                        dialog.setVisible(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog((Component)frame, i18n.NO_DIFFS_MESSAGE, "DBDiff", 1);
                    }
                });
            }
        }
        catch (SQLException e) {
            s_log.error((Object)("Encountered unexpected exception while executing diff: " + e.getMessage()), (Throwable)e);
        }
        if (encounteredException) {
            return;
        }
    }

    private Set<String> getAllTableNames(Map<String, ITableInfo> tables) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(tables.keySet());
        return result;
    }

    private Map<String, ITableInfo> getTableMap(ISQLDatabaseMetaData md, IDatabaseObjectInfo[] objs) throws SQLException {
        HashMap<String, ITableInfo> result = new HashMap<String, ITableInfo>();
        if (objs[0].getDatabaseObjectType() == DatabaseObjectType.TABLE) {
            for (int i = 0; i < objs.length; ++i) {
                IDatabaseObjectInfo info = objs[i];
                result.put(info.getSimpleName().toUpperCase(), (ITableInfo)info);
            }
        } else {
            String catalog = objs[0].getCatalogName();
            String schema = objs[0].getSchemaName();
            md.getTables(catalog, schema, null, new String[]{"TABLE"}, null);
        }
        return result;
    }

    public List<ColumnDifference> getColumnDifferences() {
        return this.colDifferences;
    }

    private boolean sanityCheck(IDatabaseObjectInfo[] sourceObjs, IDatabaseObjectInfo[] destObjs) {
        boolean result = true;
        if (sourceObjs.length != destObjs.length) {
            result = false;
        }
        if (sourceObjs[0].getDatabaseObjectType() != destObjs[0].getDatabaseObjectType()) {
            result = false;
        }
        return result;
    }

    private int[] getTableCounts() {
        int[] result = null;
        ISession sourceSession = this.prov.getDiffSourceSession();
        IDatabaseObjectInfo[] dbObjs = this.prov.getSourceSelectedDatabaseObjects();
        if (dbObjs != null) {
            result = new int[dbObjs.length];
            for (int i = 0; i < dbObjs.length; ++i) {
                if (!(dbObjs[i] instanceof ITableInfo)) continue;
                try {
                    ITableInfo ti = (ITableInfo)dbObjs[i];
                    result[i] = DBUtil.getTableCount(sourceSession, ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), 0);
                    continue;
                }
                catch (Exception e) {
                    s_log.error((Object)"Unexpected exception while attempting to get table counts", (Throwable)e);
                    result[i] = 0;
                }
            }
        }
        return result;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String NO_DIFFS_MESSAGE = DiffExecutor.access$000().getString("DiffExecutor.noDiffsMessage");
    }
}

