/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.plugins.dbdiff.ColumnDifference;

public class TableDiffExecutor {
    private ISQLDatabaseMetaData _md1;
    private ISQLDatabaseMetaData _md2;
    private ITableInfo _t1;
    private ITableInfo _t2;
    private List<ColumnDifference> colDifferences = null;

    public TableDiffExecutor(ISQLDatabaseMetaData md1, ISQLDatabaseMetaData md2) {
        this._md1 = md1;
        this._md2 = md2;
    }

    public void setTableInfos(ITableInfo t1, ITableInfo t2) {
        this._t1 = t1;
        this._t2 = t2;
        if (this.colDifferences != null) {
            this.colDifferences.clear();
        }
    }

    public void execute() throws SQLException {
        this.colDifferences = new ArrayList<ColumnDifference>();
        TableColumnInfo[] t1cols = this._md1.getColumnInfo(this._t1);
        TableColumnInfo[] t2cols = this._md2.getColumnInfo(this._t2);
        Set<String> columnNames = this.getAllColumnNames(t1cols, t2cols);
        Set<String> t1ColumnNames = this.getAllColumnNames(t1cols);
        Map<String, TableColumnInfo> t1ColMap = this.getColumnMap(t1cols);
        Set<String> t2ColumnNames = this.getAllColumnNames(t2cols);
        Map<String, TableColumnInfo> t2ColMap = this.getColumnMap(t2cols);
        for (String columnName : columnNames) {
            ColumnDifference diff = new ColumnDifference();
            if (t1ColumnNames.contains(columnName)) {
                TableColumnInfo c1 = t1ColMap.get(columnName);
                if (t2ColumnNames.contains(columnName)) {
                    TableColumnInfo c2 = t2ColMap.get(columnName);
                    diff.setColumns(c1, c2);
                } else {
                    diff.setCol2Exists(false);
                    diff.setColumn1(c1);
                }
            } else {
                diff.setCol1Exists(false);
                diff.setColumn2(t2ColMap.get(columnName));
            }
            if (!diff.execute()) continue;
            this.colDifferences.add(diff);
        }
    }

    public List<ColumnDifference> getColumnDifferences() {
        return this.colDifferences;
    }

    private Map<String, TableColumnInfo> getColumnMap(TableColumnInfo[] tci) {
        HashMap<String, TableColumnInfo> result = new HashMap<String, TableColumnInfo>();
        for (int i = 0; i < tci.length; ++i) {
            TableColumnInfo info = tci[i];
            result.put(info.getColumnName(), info);
        }
        return result;
    }

    private Set<String> getAllColumnNames(TableColumnInfo[] tci1, TableColumnInfo[] tci2) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getAllColumnNames(tci1));
        result.addAll(this.getAllColumnNames(tci2));
        return result;
    }

    private Set<String> getAllColumnNames(TableColumnInfo[] tci) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < tci.length; ++i) {
            TableColumnInfo info = tci[i];
            result.add(info.getColumnName());
        }
        return result;
    }

    private static class ColumnComparator
    implements Comparator<TableColumnInfo> {
        private ColumnComparator() {
        }

        @Override
        public int compare(TableColumnInfo arg0, TableColumnInfo arg1) {
            return arg0.getColumnName().compareToIgnoreCase(arg1.getColumnName());
        }
    }
}

