/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IUDTInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.mssql.MssqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mssql.util.DatabaseObjectInfoRenderer;
import net.sourceforge.squirrel_sql.plugins.mssql.util.DatabaseObjectInfoTableModel;
import net.sourceforge.squirrel_sql.plugins.mssql.util.MssqlIntrospector;

public class GenerateSqlDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GenerateSqlDialog.class);
    private ISession _session;
    private MssqlPlugin _plugin;
    private IDatabaseObjectInfo[] _dbObjs;
    private JTable _availableTable;
    private JTable _selectedTable;
    private JCheckBox _generateCreateCheckbox;
    private JCheckBox _generateDropCheckbox;
    private JCheckBox _generateDependentCheckbox;
    private JCheckBox _includeHeadersCheckbox;
    private JCheckBox _extendedPropsCheckbox;
    private JCheckBox _onlySevenCheckbox;
    private JTextArea _templateArea;
    private JCheckBox _scriptDatabaseCheckbox;
    private JCheckBox _scriptUsersAndRolesCheckbox;
    private JCheckBox _scriptLoginsCheckbox;
    private JCheckBox _scriptPermissionsCheckbox;
    private JCheckBox _scriptIndexesCheckbox;
    private JCheckBox _scriptFTIndexesCheckbox;
    private JCheckBox _scriptTriggersCheckbox;
    private JCheckBox _scriptConstraintsCheckbox;
    private JRadioButton _OEMRadio;
    private JRadioButton _ANSIRadio;
    private JRadioButton _UnicodeRadio;
    private JRadioButton _oneFileRadio;
    private JRadioButton _separateFilesRadio;
    private boolean _wasCompleted;

    public GenerateSqlDialog(ISession session, MssqlPlugin plugin, IDatabaseObjectInfo[] dbObjs) throws SQLException {
        super(GenerateSqlDialog.ctorHelper(session, plugin, dbObjs), true);
        this._session = session;
        this._plugin = plugin;
        this._dbObjs = dbObjs;
        this._wasCompleted = false;
        this.createGUI();
    }

    private void createGUI() throws SQLException {
        this.setTitle(s_stringMgr.getString("mssql.generateSqlScript"));
        this.setContentPane(this.buildContentPane());
    }

    private JComponent buildContentPane() throws SQLException {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.buildMainPanel(), "Center");
        pnl.add((Component)this.buildToolBar(), "South");
        pnl.setBorder(Borders.TABBED_DIALOG_BORDER);
        return pnl;
    }

    private JTabbedPane buildMainPanel() throws SQLException {
        JTabbedPane tabPanel = UIFactory.getInstance().createTabbedPane();
        tabPanel.addTab(s_stringMgr.getString("mssql.general"), null, this.buildGeneralPanel());
        tabPanel.addTab(s_stringMgr.getString("mssql.foematting"), null, this.buildFormattingPanel());
        tabPanel.addTab(s_stringMgr.getString("mssql.options"), null, this.buildOptionsPanel());
        return tabPanel;
    }

    private JPanel buildGeneralPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        JLabel objectsLabel = new JLabel();
        objectsLabel.setText(s_stringMgr.getString("mssql.toScript"));
        gridBag.setConstraints(objectsLabel, c);
        panel.add(objectsLabel);
        JCheckBox allObjectsCheckbox = new JCheckBox(s_stringMgr.getString("mssql.allObjects"));
        final JCheckBox allTablesCheckbox = new JCheckBox(s_stringMgr.getString("mssql.allTables"));
        final JCheckBox allRulesCheckbox = new JCheckBox(s_stringMgr.getString("mssql.allRules"));
        final JCheckBox allViewsCheckbox = new JCheckBox(s_stringMgr.getString("mssql.allViews"));
        final JCheckBox allUddtCheckbox = new JCheckBox(s_stringMgr.getString("mssql.allUserDef"));
        final JCheckBox allProceduresCheckbox = new JCheckBox(s_stringMgr.getString("mssql.allSps"));
        final JCheckBox allUdfsCheckbox = new JCheckBox(s_stringMgr.getString("mssql.allUDFs"));
        final JCheckBox allDefaultsCheckbox = new JCheckBox(s_stringMgr.getString("mssql.allDefaults"));
        c.gridx = 0;
        c.gridy = 1;
        allObjectsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GenerateSqlDialog.this.transferObjectsOfType(0, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel());
                } else if (e.getStateChange() == 2) {
                    GenerateSqlDialog.this.transferObjectsOfType(0, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel());
                }
                boolean isSelected = e.getStateChange() == 1;
                allTablesCheckbox.setSelected(isSelected);
                allRulesCheckbox.setSelected(isSelected);
                allViewsCheckbox.setSelected(isSelected);
                allUddtCheckbox.setSelected(isSelected);
                allProceduresCheckbox.setSelected(isSelected);
                allUdfsCheckbox.setSelected(isSelected);
                allDefaultsCheckbox.setSelected(isSelected);
                allTablesCheckbox.setEnabled(!isSelected);
                allRulesCheckbox.setEnabled(!isSelected);
                allViewsCheckbox.setEnabled(!isSelected);
                allUddtCheckbox.setEnabled(!isSelected);
                allProceduresCheckbox.setEnabled(!isSelected);
                allUdfsCheckbox.setEnabled(!isSelected);
                allDefaultsCheckbox.setEnabled(!isSelected);
            }
        });
        gridBag.setConstraints(allObjectsCheckbox, c);
        panel.add(allObjectsCheckbox);
        c.gridx = 0;
        c.gridy = 2;
        allTablesCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GenerateSqlDialog.this.transferObjectsOfType(1, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel());
                } else if (e.getStateChange() == 2) {
                    GenerateSqlDialog.this.transferObjectsOfType(1, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel());
                }
            }
        });
        gridBag.setConstraints(allTablesCheckbox, c);
        panel.add(allTablesCheckbox);
        c.gridx = 2;
        c.gridy = 2;
        allRulesCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GenerateSqlDialog.this.transferObjectsOfType(6, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel());
                } else if (e.getStateChange() == 2) {
                    GenerateSqlDialog.this.transferObjectsOfType(6, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel());
                }
            }
        });
        gridBag.setConstraints(allRulesCheckbox, c);
        panel.add(allRulesCheckbox);
        c.gridx = 0;
        c.gridy = 3;
        allViewsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GenerateSqlDialog.this.transferObjectsOfType(2, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel());
                } else if (e.getStateChange() == 2) {
                    GenerateSqlDialog.this.transferObjectsOfType(2, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel());
                }
            }
        });
        gridBag.setConstraints(allViewsCheckbox, c);
        panel.add(allViewsCheckbox);
        c.gridx = 2;
        c.gridy = 3;
        allUddtCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GenerateSqlDialog.this.transferObjectsOfType(5, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel());
                } else if (e.getStateChange() == 2) {
                    GenerateSqlDialog.this.transferObjectsOfType(5, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel());
                }
            }
        });
        gridBag.setConstraints(allUddtCheckbox, c);
        panel.add(allUddtCheckbox);
        c.gridx = 0;
        c.gridy = 4;
        allProceduresCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GenerateSqlDialog.this.transferObjectsOfType(3, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel());
                } else if (e.getStateChange() == 2) {
                    GenerateSqlDialog.this.transferObjectsOfType(3, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel());
                }
            }
        });
        gridBag.setConstraints(allProceduresCheckbox, c);
        panel.add(allProceduresCheckbox);
        c.gridx = 2;
        c.gridy = 4;
        allUdfsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GenerateSqlDialog.this.transferObjectsOfType(4, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel());
                } else if (e.getStateChange() == 2) {
                    GenerateSqlDialog.this.transferObjectsOfType(4, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel());
                }
            }
        });
        gridBag.setConstraints(allUdfsCheckbox, c);
        panel.add(allUdfsCheckbox);
        c.gridx = 0;
        c.gridy = 5;
        allDefaultsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GenerateSqlDialog.this.transferObjectsOfType(7, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel());
                } else if (e.getStateChange() == 2) {
                    GenerateSqlDialog.this.transferObjectsOfType(7, (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._selectedTable.getModel(), (DatabaseObjectInfoTableModel)GenerateSqlDialog.this._availableTable.getModel());
                }
            }
        });
        gridBag.setConstraints(allDefaultsCheckbox, c);
        panel.add(allDefaultsCheckbox);
        JLabel availableLabel = new JLabel();
        c.gridx = 0;
        c.gridy = 6;
        objectsLabel.setText(s_stringMgr.getString("mssql.objectsOn", new Object[]{this._dbObjs[0].getCatalogName()}));
        gridBag.setConstraints(availableLabel, c);
        panel.add(availableLabel);
        JLabel selectedLabel = new JLabel();
        c.gridx = 2;
        c.gridy = 6;
        objectsLabel.setText("Objects to be scripted:");
        gridBag.setConstraints(selectedLabel, c);
        panel.add(selectedLabel);
        JButton addButton = new JButton();
        c.gridx = 1;
        c.gridy = 8;
        addButton.setText(s_stringMgr.getString("mssql.add"));
        addButton.setMnemonic("A".charAt(0));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateSqlDialog.this.transferSelectedItems(GenerateSqlDialog.this._availableTable, GenerateSqlDialog.this._selectedTable);
            }
        });
        gridBag.setConstraints(addButton, c);
        panel.add(addButton);
        JButton removeButton = new JButton();
        c.gridx = 1;
        c.gridy = 9;
        removeButton.setText(s_stringMgr.getString("mssql.remove"));
        removeButton.setMnemonic(s_stringMgr.getString("mssql.remove_Mnemonic").charAt(0));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateSqlDialog.this.transferSelectedItems(GenerateSqlDialog.this._selectedTable, GenerateSqlDialog.this._availableTable);
            }
        });
        gridBag.setConstraints(removeButton, c);
        panel.add(removeButton);
        this._availableTable = new JTable(new DefaultTableModel(0, 0));
        this._availableTable.setModel(new DatabaseObjectInfoTableModel());
        this._availableTable.getColumnModel().getColumn(0).setCellRenderer(new DatabaseObjectInfoRenderer());
        JScrollPane availablePane = new JScrollPane(this._availableTable);
        c.gridx = 0;
        c.gridy = 7;
        c.gridheight = 3;
        gridBag.setConstraints(availablePane, c);
        panel.add(availablePane);
        this.populateAvailableTable(this._availableTable);
        this._selectedTable = new JTable(new DefaultTableModel(0, 0));
        this._selectedTable.setModel(new DatabaseObjectInfoTableModel());
        this._selectedTable.getColumnModel().getColumn(0).setCellRenderer(new DatabaseObjectInfoRenderer());
        JScrollPane selectedPane = new JScrollPane(this._selectedTable);
        c.gridx = 2;
        c.gridy = 7;
        c.gridheight = 3;
        gridBag.setConstraints(selectedPane, c);
        panel.add(selectedPane);
        return panel;
    }

    private void transferObjectsOfType(int mssqlType, DatabaseObjectInfoTableModel fromModel, DatabaseObjectInfoTableModel toModel) {
        int i = 0;
        while (i < fromModel.getRowCount()) {
            IDatabaseObjectInfo oi = (IDatabaseObjectInfo)fromModel.getValueAt(i, 0);
            if (mssqlType == 0 || MssqlIntrospector.getObjectInfoType(oi) == mssqlType) {
                if (!fromModel.removeElement(oi)) continue;
                toModel.addElement(oi);
                continue;
            }
            ++i;
        }
    }

    private void transferSelectedItems(JTable fromTable, JTable toTable) {
        DatabaseObjectInfoTableModel fromModel = (DatabaseObjectInfoTableModel)fromTable.getModel();
        DatabaseObjectInfoTableModel toModel = (DatabaseObjectInfoTableModel)toTable.getModel();
        int[] selectedRows = fromTable.getSelectedRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            IDatabaseObjectInfo oi = (IDatabaseObjectInfo)fromModel.getValueAt(selectedRows[i], 0);
            if (!fromModel.removeElement(oi)) continue;
            toModel.addElement(oi);
        }
    }

    private void populateAvailableTable(JTable table) {
        DatabaseObjectInfoTableModel model = (DatabaseObjectInfoTableModel)table.getModel();
        try {
            int i;
            String catalog = this._session.getSQLConnection().getCatalog();
            SQLDatabaseMetaData metaData = this._session.getSQLConnection().getSQLMetaData();
            ITableInfo[] tables = this._session.getSchemaInfo().getITableInfos(catalog, null, new ObjFilterMatcher(), new String[]{"TABLE"});
            for (i = 0; i < tables.length; ++i) {
                model.addElement((IDatabaseObjectInfo)tables[i]);
            }
            ITableInfo[] views = this._session.getSchemaInfo().getITableInfos(catalog, null, new ObjFilterMatcher(), new String[]{"VIEW"});
            for (i = 0; i < views.length; ++i) {
                model.addElement((IDatabaseObjectInfo)views[i]);
            }
            IProcedureInfo[] procs = this._session.getSchemaInfo().getStoredProceduresInfos(catalog, null, new ObjFilterMatcher());
            for (i = 0; i < procs.length; ++i) {
                if (procs[i].getSimpleName().startsWith("dt_")) continue;
                model.addElement((IDatabaseObjectInfo)procs[i]);
            }
            IUDTInfo[] udts = metaData.getUDTs(catalog, null, null, null);
            for (i = 0; i < udts.length; ++i) {
                model.addElement((IDatabaseObjectInfo)udts[i]);
            }
        }
        catch (SQLException ex) {
            this._session.getApplication().showErrorDialog(ex.getMessage(), (Throwable)ex);
        }
    }

    private JPanel buildFormattingPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        JLabel optionsLabel = new JLabel();
        optionsLabel.setText(s_stringMgr.getString("mssql.scriptingOptionsDlg"));
        gridBag.setConstraints(optionsLabel, c);
        panel.add(optionsLabel);
        this._generateCreateCheckbox = new JCheckBox(s_stringMgr.getString("mssql.genereateCreate"), true);
        c.gridx = 0;
        c.gridy = 1;
        this._generateCreateCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GenerateSqlDialog.this.scriptOptionsChanged();
            }
        });
        gridBag.setConstraints(this._generateCreateCheckbox, c);
        panel.add(this._generateCreateCheckbox);
        this._generateDropCheckbox = new JCheckBox(s_stringMgr.getString("mssql.generateDrop"), true);
        c.gridx = 0;
        c.gridy = 2;
        this._generateDropCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GenerateSqlDialog.this.scriptOptionsChanged();
            }
        });
        gridBag.setConstraints(this._generateDropCheckbox, c);
        panel.add(this._generateDropCheckbox);
        this._generateDependentCheckbox = new JCheckBox(s_stringMgr.getString("mssql.generateDependend"), false);
        c.gridx = 0;
        c.gridy = 3;
        this._generateDependentCheckbox.setEnabled(false);
        this._generateDependentCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GenerateSqlDialog.this.scriptOptionsChanged();
            }
        });
        gridBag.setConstraints(this._generateDependentCheckbox, c);
        panel.add(this._generateDependentCheckbox);
        this._includeHeadersCheckbox = new JCheckBox(s_stringMgr.getString("mssql.includeHeaders"), false);
        c.gridx = 0;
        c.gridy = 4;
        this._includeHeadersCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GenerateSqlDialog.this.scriptOptionsChanged();
            }
        });
        gridBag.setConstraints(this._includeHeadersCheckbox, c);
        panel.add(this._includeHeadersCheckbox);
        this._extendedPropsCheckbox = new JCheckBox(s_stringMgr.getString("mssql.extProps"), false);
        c.gridx = 0;
        c.gridy = 5;
        this._extendedPropsCheckbox.setEnabled(false);
        this._extendedPropsCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GenerateSqlDialog.this.scriptOptionsChanged();
            }
        });
        gridBag.setConstraints(this._extendedPropsCheckbox, c);
        panel.add(this._extendedPropsCheckbox);
        this._onlySevenCheckbox = new JCheckBox(s_stringMgr.getString("mssql.only70compatible"), false);
        c.gridx = 0;
        c.gridy = 6;
        this._onlySevenCheckbox.setEnabled(false);
        this._onlySevenCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GenerateSqlDialog.this.scriptOptionsChanged();
            }
        });
        gridBag.setConstraints(this._onlySevenCheckbox, c);
        panel.add(this._onlySevenCheckbox);
        JLabel templateLabel = new JLabel();
        c.gridx = 0;
        c.gridy = 7;
        templateLabel.setText(s_stringMgr.getString("mssql.scriptTemplate"));
        gridBag.setConstraints(templateLabel, c);
        panel.add(templateLabel);
        this._templateArea = new JTextArea();
        JScrollPane templatePane = new JScrollPane(this._templateArea);
        c.gridx = 0;
        c.gridy = 8;
        c.weightx = 2.0;
        c.weighty = 2.0;
        this._templateArea.setEditable(false);
        gridBag.setConstraints(templatePane, c);
        panel.add(templatePane);
        this.scriptOptionsChanged();
        return panel;
    }

    private void scriptOptionsChanged() {
        boolean generateCreate = this._generateCreateCheckbox.isSelected();
        boolean generateDrop = this._generateDropCheckbox.isSelected();
        boolean generateDependent = this._generateDependentCheckbox.isSelected();
        boolean includeHeaders = this._includeHeadersCheckbox.isSelected();
        StringBuffer buf = new StringBuffer();
        if (includeHeaders) {
            buf.append("/* OBJECT: table: SampleTable  SCRIPT DATE: 1/1/1999 */\n\n");
        }
        if (generateDependent) {
            buf.append("sp_addtype SampleUDT, int\nGO\n\n");
        }
        if (generateDrop) {
            buf.append("DROP TABLE SampleTable\nGO\n\n");
        }
        if (generateCreate) {
            buf.append("CREATE TABLE SampleTable\n(SampleColumn1 datetime NULL,\nSampleColumn2 SampleUDT)\nGO\n\n");
        }
        this._templateArea.setText(buf.toString());
    }

    private JPanel buildOptionsPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        JPanel securityPanel = new JPanel();
        securityPanel.setBorder(BorderFactory.createTitledBorder("Security Scripting Options"));
        GridBagLayout securityBag = new GridBagLayout();
        securityPanel.setLayout(securityBag);
        c.gridx = 0;
        c.gridy = 0;
        gridBag.setConstraints(securityPanel, c);
        panel.add(securityPanel);
        this._scriptDatabaseCheckbox = new JCheckBox(s_stringMgr.getString("mssql.scriptDatabase"));
        c.gridx = 0;
        c.gridy = 0;
        securityBag.setConstraints(this._scriptDatabaseCheckbox, c);
        securityPanel.add(this._scriptDatabaseCheckbox);
        this._scriptUsersAndRolesCheckbox = new JCheckBox(s_stringMgr.getString("mssql.scriptUsers"));
        c.gridx = 0;
        c.gridy = 1;
        securityBag.setConstraints(this._scriptUsersAndRolesCheckbox, c);
        securityPanel.add(this._scriptUsersAndRolesCheckbox);
        this._scriptLoginsCheckbox = new JCheckBox(s_stringMgr.getString("mssql.scriptLogins"));
        c.gridx = 0;
        c.gridy = 2;
        this._scriptLoginsCheckbox.setEnabled(false);
        securityBag.setConstraints(this._scriptLoginsCheckbox, c);
        securityPanel.add(this._scriptLoginsCheckbox);
        this._scriptPermissionsCheckbox = new JCheckBox(s_stringMgr.getString("mssql.scriptPermission"));
        c.gridx = 0;
        c.gridy = 3;
        securityBag.setConstraints(this._scriptPermissionsCheckbox, c);
        securityPanel.add(this._scriptPermissionsCheckbox);
        JPanel tablePanel = new JPanel();
        tablePanel.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("mssql.scriptingOptions")));
        GridBagLayout tableBag = new GridBagLayout();
        tablePanel.setLayout(tableBag);
        c.gridx = 0;
        c.gridy = 1;
        gridBag.setConstraints(tablePanel, c);
        panel.add(tablePanel);
        this._scriptIndexesCheckbox = new JCheckBox(s_stringMgr.getString("mssql.scriptIndexses"));
        c.gridx = 0;
        c.gridy = 0;
        tableBag.setConstraints(this._scriptIndexesCheckbox, c);
        tablePanel.add(this._scriptIndexesCheckbox);
        this._scriptFTIndexesCheckbox = new JCheckBox(s_stringMgr.getString("mssql.scriptFullText"));
        c.gridx = 0;
        c.gridy = 1;
        this._scriptFTIndexesCheckbox.setEnabled(false);
        tableBag.setConstraints(this._scriptFTIndexesCheckbox, c);
        tablePanel.add(this._scriptFTIndexesCheckbox);
        this._scriptTriggersCheckbox = new JCheckBox("Script triggers");
        c.gridx = 0;
        c.gridy = 2;
        tableBag.setConstraints(this._scriptTriggersCheckbox, c);
        tablePanel.add(this._scriptTriggersCheckbox);
        this._scriptConstraintsCheckbox = new JCheckBox(s_stringMgr.getString("mssql.scriptPrimary"));
        c.gridx = 0;
        c.gridy = 3;
        tableBag.setConstraints(this._scriptConstraintsCheckbox, c);
        tablePanel.add(this._scriptConstraintsCheckbox);
        JPanel fileOptionsPanel = new JPanel();
        fileOptionsPanel.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("mssql.fileOptions")));
        c.gridx = 0;
        c.gridy = 2;
        gridBag.setConstraints(fileOptionsPanel, c);
        panel.add(fileOptionsPanel);
        JPanel fileFormatPanel = new JPanel();
        fileFormatPanel.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("mssql.fileFormat")));
        fileOptionsPanel.add(fileFormatPanel);
        ButtonGroup fileFormatGroup = new ButtonGroup();
        this._OEMRadio = new JRadioButton(s_stringMgr.getString("mssql.msdos"));
        this._ANSIRadio = new JRadioButton(s_stringMgr.getString("mssql.windows"));
        this._UnicodeRadio = new JRadioButton(s_stringMgr.getString("mssql.unicode"), true);
        fileFormatGroup.add(this._OEMRadio);
        fileFormatGroup.add(this._ANSIRadio);
        fileFormatGroup.add(this._UnicodeRadio);
        fileFormatPanel.add(this._OEMRadio);
        fileFormatPanel.add(this._ANSIRadio);
        fileFormatPanel.add(this._UnicodeRadio);
        this._OEMRadio.setEnabled(false);
        this._ANSIRadio.setEnabled(false);
        JPanel generatePanel = new JPanel();
        generatePanel.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("mssql.filesToGenerate")));
        fileOptionsPanel.add(generatePanel);
        ButtonGroup generateGroup = new ButtonGroup();
        this._oneFileRadio = new JRadioButton(s_stringMgr.getString("mssql.oneFile"), true);
        this._separateFilesRadio = new JRadioButton(s_stringMgr.getString("mssql.oneFilePerObject"));
        generateGroup.add(this._oneFileRadio);
        generateGroup.add(this._separateFilesRadio);
        generatePanel.add(this._oneFileRadio);
        generatePanel.add(this._separateFilesRadio);
        return panel;
    }

    private JPanel buildToolBar() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        final GenerateSqlDialog dlg = this;
        JButton okButton = new JButton(s_stringMgr.getString("mssql.ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateSqlDialog.this._wasCompleted = true;
                dlg.setVisible(false);
            }
        });
        builder.addGridded((JComponent)okButton);
        builder.addRelatedGap();
        JButton cancelButton = new JButton(s_stringMgr.getString("mssql.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateSqlDialog.this._wasCompleted = false;
                dlg.setVisible(false);
            }
        });
        builder.addGridded((JComponent)cancelButton);
        return builder.getPanel();
    }

    private static Frame ctorHelper(ISession session, MssqlPlugin plugin, IDatabaseObjectInfo[] dbObjs) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("MssqlPlugin == null");
        }
        if (dbObjs == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo[] is null");
        }
        return session.getApplication().getMainFrame();
    }

    public ArrayList<IDatabaseObjectInfo> getSelectedItems() {
        return ((DatabaseObjectInfoTableModel)this._selectedTable.getModel()).getContents();
    }

    public boolean getGenerateCreate() {
        return this._generateCreateCheckbox.isSelected();
    }

    public boolean getGenerateDrop() {
        return this._generateDropCheckbox.isSelected();
    }

    public boolean getGenerateDependent() {
        return this._generateDependentCheckbox.isSelected();
    }

    public boolean getIncludeHeaders() {
        return this._includeHeadersCheckbox.isSelected();
    }

    public boolean getExtendedProps() {
        return this._extendedPropsCheckbox.isSelected();
    }

    public boolean getOnlySeven() {
        return this._onlySevenCheckbox.isSelected();
    }

    public boolean getScriptDatabase() {
        return this._scriptDatabaseCheckbox.isSelected();
    }

    public boolean getScriptUsersAndRoles() {
        return this._scriptUsersAndRolesCheckbox.isSelected();
    }

    public boolean getScriptLogins() {
        return this._scriptLoginsCheckbox.isSelected();
    }

    public boolean getScriptPermissions() {
        return this._scriptPermissionsCheckbox.isSelected();
    }

    public boolean getScriptIndexes() {
        return this._scriptIndexesCheckbox.isSelected();
    }

    public boolean getScriptFTIndexes() {
        return this._scriptFTIndexesCheckbox.isSelected();
    }

    public boolean getScriptTriggers() {
        return this._scriptTriggersCheckbox.isSelected();
    }

    public boolean getScriptConstraints() {
        return this._scriptConstraintsCheckbox.isSelected();
    }

    public boolean getOEM() {
        return this._OEMRadio.isSelected();
    }

    public boolean getANSI() {
        return this._ANSIRadio.isSelected();
    }

    public boolean getUnicode() {
        return this._UnicodeRadio.isSelected();
    }

    public boolean getOneFile() {
        return this._oneFileRadio.isSelected();
    }

    public boolean showGeneralSqlDialog() {
        this.setVisible(true);
        return this._wasCompleted;
    }

    public void preselectObjects(IDatabaseObjectInfo[] objs) {
        DatabaseObjectInfoTableModel fromModel = (DatabaseObjectInfoTableModel)this._availableTable.getModel();
        DatabaseObjectInfoTableModel toModel = (DatabaseObjectInfoTableModel)this._selectedTable.getModel();
        for (int i = 0; i < objs.length; ++i) {
            if (!fromModel.removeElement(objs[i])) continue;
            toModel.addElement(objs[i]);
        }
    }
}

