/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.dboutput;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrame;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrameCallback;
import net.sourceforge.squirrel_sql.plugins.oracle.dboutput.ClearDBOutputAction;
import net.sourceforge.squirrel_sql.plugins.oracle.dboutput.DBOutputPanel;
import net.sourceforge.squirrel_sql.plugins.oracle.dboutput.GetDBOutputAction;

public class DBOutputInternalFrame
extends OracleInternalFrame {
    private static final String PREF_PART_DB_OUTPUT_FRAME = "DBOutputFrame";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DBOutputInternalFrame.class);
    private final IApplication _app;
    private IIdentifier _sessionId;
    private DBOutputPanel _dbOutputPanel;
    private DBOutputToolBar _toolBar;
    private Resources _resources;

    public DBOutputInternalFrame(ISession session, Resources resources) {
        super(session, s_stringMgr.getString("oracle.dbOutputTitle", new Object[]{session.getTitle()}));
        this._app = session.getApplication();
        this._resources = resources;
        this._sessionId = session.getIdentifier();
        this.createGUI(session);
    }

    public DBOutputPanel getDBOutputPanel() {
        return this._dbOutputPanel;
    }

    private void createGUI(ISession session) {
        this.addWidgetListener((WidgetListener)new WidgetAdapter(){

            public void widgetClosing(WidgetEvent e) {
                DBOutputInternalFrame.this.onWidgetClosing();
            }
        });
        ImageIcon icon = this._resources.getIcon(((Object)((Object)this)).getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        OracleInternalFrameCallback cb = new OracleInternalFrameCallback(){

            @Override
            public void createPanelAndToolBar(boolean stayOnTop, int autoRefeshPeriod) {
                DBOutputInternalFrame.this._dbOutputPanel = new DBOutputPanel(DBOutputInternalFrame.this.getSession(), autoRefeshPeriod);
                DBOutputInternalFrame.this._toolBar = new DBOutputToolBar(DBOutputInternalFrame.this.getSession(), stayOnTop, autoRefeshPeriod);
                JPanel contentPanel = new JPanel(new BorderLayout());
                contentPanel.add((Component)((Object)DBOutputInternalFrame.this._toolBar), "North");
                contentPanel.add((Component)DBOutputInternalFrame.this._dbOutputPanel, "Center");
                DBOutputInternalFrame.this.setContentPane(contentPanel);
                DBOutputInternalFrame.this._dbOutputPanel.setAutoRefreshPeriod(autoRefeshPeriod);
            }
        };
        this.initFromPrefs(PREF_PART_DB_OUTPUT_FRAME, cb);
    }

    private void onWidgetClosing() {
        this.internalFrameClosing(this._toolBar.isStayOnTop(), this._dbOutputPanel.getAutoRefreshPeriod());
        this._dbOutputPanel.setAutoRefresh(false);
    }

    private class DBOutputToolBar
    extends OracleInternalFrame.OracleToolBar {
        private JCheckBox _autoRefresh;

        DBOutputToolBar(ISession session, boolean stayOnTop, int autoRefeshPeriod) {
            this.createGUI(session, stayOnTop, autoRefeshPeriod);
        }

        private void createGUI(ISession session, boolean stayOnTop, int autoRefeshPeriod) {
            IApplication app = session.getApplication();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add((Action)((Object)new GetDBOutputAction(app, DBOutputInternalFrame.this._resources, DBOutputInternalFrame.this._dbOutputPanel)));
            this.add((Action)((Object)new ClearDBOutputAction(app, DBOutputInternalFrame.this._resources, DBOutputInternalFrame.this._dbOutputPanel)));
            this.addStayOnTop(stayOnTop);
            this._autoRefresh = new JCheckBox(s_stringMgr.getString("oracle.dboutputEnableAutoRefer"), false);
            this._autoRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBOutputInternalFrame.this._dbOutputPanel.setAutoRefresh(DBOutputToolBar.this._autoRefresh.isSelected());
                }
            });
            this.add(this._autoRefresh);
            final SpinnerNumberModel model = new SpinnerNumberModel(autoRefeshPeriod, 1, 60, 5);
            JSpinner refreshRate = new JSpinner(model);
            refreshRate.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DBOutputInternalFrame.this._dbOutputPanel.setAutoRefreshPeriod(model.getNumber().intValue());
                }
            });
            this.add(refreshRate);
            this.add(new JLabel(s_stringMgr.getString("oracle.Seconds2")));
        }
    }
}

