/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.expander;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.ObjectType;

public class ObjectTypeExpander
implements INodeExpander {
    private static String SQL = "select object_name from sys.all_objects where object_type = ? and owner = ? and object_name like ? order by object_name";
    private ObjectType _objectType;

    ObjectTypeExpander(ObjectType objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("ObjectType == null");
        }
        this._objectType = objectType;
    }

    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSchemaName();
        childNodes.addAll(this.createNodes(session, catalogName, schemaName));
        return childNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ObjectTreeNode> createNodes(ISession session, String catalogName, String schemaName) throws SQLException {
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = conn.getSQLMetaData();
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        ObjFilterMatcher filterMatcher = new ObjFilterMatcher(session.getProperties());
        PreparedStatement pstmt = conn.prepareStatement(SQL);
        try {
            pstmt.setString(1, this._objectType._objectTypeColumnData);
            pstmt.setString(2, schemaName);
            pstmt.setString(3, filterMatcher.getSqlLikeMatchString());
            ResultSet rs = pstmt.executeQuery();
            try {
                while (rs.next()) {
                    DatabaseObjectInfo dbinfo = new DatabaseObjectInfo(catalogName, schemaName, rs.getString(1), this._objectType._childDboType, (ISQLDatabaseMetaData)md);
                    if (!filterMatcher.matches(dbinfo.getSimpleName())) continue;
                    childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)dbinfo));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            pstmt.close();
        }
        return childNodes;
    }
}

