/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.expander;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IObjectTypes;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.ObjectType;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.ObjectTypeExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.PackageParentExpander;
import net.sourceforge.squirrel_sql.plugins.oracle.expander.SequenceParentExpander;

public class SchemaExpander
implements INodeExpander {
    private IObjectTypes _objectTypes;

    public SchemaExpander(IObjectTypes objectTypes) {
        this._objectTypes = objectTypes;
    }

    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSimpleName();
        DatabaseObjectInfo dbinfo = new DatabaseObjectInfo(catalogName, schemaName, "PACKAGE", this._objectTypes.getPackageParent(), (ISQLDatabaseMetaData)md);
        ObjectTreeNode child = new ObjectTreeNode(session, (IDatabaseObjectInfo)dbinfo);
        child.addExpander((INodeExpander)new PackageParentExpander(this._objectTypes));
        childNodes.add(child);
        ObjectType objType = new ObjectType(this._objectTypes.getConsumerGroupParent(), "CONSUMER GROUP", this._objectTypes.getConsumerGroup());
        childNodes.add(this.createObjectTypeNode(session, catalogName, schemaName, md, objType));
        objType = new ObjectType(this._objectTypes.getFunctionParent(), "FUNCTION", DatabaseObjectType.FUNCTION);
        childNodes.add(this.createObjectTypeNode(session, catalogName, schemaName, md, objType));
        objType = new ObjectType(this._objectTypes.getIndexParent(), "INDEX", DatabaseObjectType.INDEX);
        childNodes.add(this.createObjectTypeNode(session, catalogName, schemaName, md, objType));
        objType = new ObjectType(this._objectTypes.getLobParent(), "LOB", this._objectTypes.getLob());
        childNodes.add(this.createObjectTypeNode(session, catalogName, schemaName, md, objType));
        DatabaseObjectInfo seqInfo = new DatabaseObjectInfo(catalogName, schemaName, "SEQUENCE", this._objectTypes.getSequenceParent(), (ISQLDatabaseMetaData)md);
        ObjectTreeNode node = new ObjectTreeNode(session, (IDatabaseObjectInfo)seqInfo);
        node.addExpander((INodeExpander)new SequenceParentExpander());
        childNodes.add(node);
        objType = new ObjectType(this._objectTypes.getTypeParent(), "TYPE", this._objectTypes.getType());
        childNodes.add(this.createObjectTypeNode(session, catalogName, schemaName, md, objType));
        return childNodes;
    }

    private ObjectTreeNode createObjectTypeNode(ISession session, String catalogName, String schemaName, SQLDatabaseMetaData md, ObjectType objType) {
        DatabaseObjectInfo dbinfo = new DatabaseObjectInfo(catalogName, schemaName, objType._objectTypeColumnData, objType._dboType, (ISQLDatabaseMetaData)md);
        ObjectTreeNode node = new ObjectTreeNode(session, (IDatabaseObjectInfo)dbinfo);
        node.addExpander((INodeExpander)new ObjectTypeExpander(objType));
        return node;
    }
}

