/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.explain;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecuter;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLExecutionException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.postgres.explain.ExplainTab;

public class ExplainExecuterPanel
extends JPanel
implements ISQLResultExecuter {
    private static final long serialVersionUID = 9155604319585792834L;
    private static final ILogger s_log = LoggerController.createLogger(ExplainExecuterPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExplainExecuterPanel.class);
    private ISession _session;
    private DialectType _dialectType;
    private JTabbedPane _tabbedExecutionsPanel;

    public ExplainExecuterPanel(ISession session) {
        this._session = session;
        this._dialectType = DialectFactory.getDialectType((ISQLDatabaseMetaData)this._session.getMetaData());
        this._session.getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ExplainExecuterPanel.this.onPropertyChange(evt.getPropertyName());
            }
        });
        this.createGUI();
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this._tabbedExecutionsPanel = UIFactory.getInstance().createTabbedPane(this._session.getProperties().getSQLExecutionTabPlacement());
        this.initTabPopup();
        this.add((Component)this._tabbedExecutionsPanel, "Center");
    }

    public void execute(ISQLEntryPanel parent) {
        String sql = parent.getSQLToBeExecuted();
        if (sql == null || sql.length() == 0) {
            return;
        }
        try {
            SQLExecuterTask executer = new SQLExecuterTask(this._session, this.getExplainSql(sql), (ISQLExecuterHandler)new SQLExecutionHandler());
            this._session.getApplication().getThreadPool().addTask((Runnable)executer);
        }
        catch (UnsupportedStatementException e) {
            this._session.showErrorMessage(i18n.ONLY_SELECT_ALLOWED);
        }
    }

    private String getExplainSql(String sql) throws UnsupportedStatementException {
        StringBuilder result = new StringBuilder();
        IQueryTokenizer tokenizer = this._session.getQueryTokenizer();
        tokenizer.setScriptToTokenize(sql);
        while (tokenizer.hasQuery()) {
            String query = tokenizer.nextQuery();
            if (query.toLowerCase().startsWith("select")) {
                result.append(i18n.EXPLAIN_SQL_PREFIX).append(query).append(tokenizer.getSQLStatementSeparator());
                continue;
            }
            throw new UnsupportedStatementException();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getExplainSql - Input: " + sql));
            s_log.debug((Object)("getExplainSql - Querys: " + tokenizer.getQueryCount()));
            s_log.debug((Object)("getExplainSql - Result: " + result));
        }
        return result.toString();
    }

    private void addExplainTab(ResultSetDataSet rsds, SQLExecutionInfo info, IDataSetUpdateableTableModel model) {
        final ExplainTab tab = new ExplainTab(this._session, this, rsds, info, model);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExplainExecuterPanel.this.secureAddTab(tab);
            }
        });
    }

    public void closeTab(final ExplainTab tab) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExplainExecuterPanel.this._tabbedExecutionsPanel.removeTabAt(ExplainExecuterPanel.this._tabbedExecutionsPanel.indexOfComponent(tab));
            }
        });
    }

    public void closeTabAt(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExplainExecuterPanel.this._tabbedExecutionsPanel.removeTabAt(index);
            }
        });
    }

    private void secureAddTab(ExplainTab tab) {
        SessionProperties props = this._session.getProperties();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("secureAddTab - TabCount: " + this._tabbedExecutionsPanel.getTabCount()));
            s_log.debug((Object)("secureAddTab - Limited?: " + props.getLimitSQLResultTabs()));
            s_log.debug((Object)("secureAddTab - TabLimit: " + props.getSqlResultTabLimit()));
        }
        if (props.getLimitSQLResultTabs() && props.getSqlResultTabLimit() <= this._tabbedExecutionsPanel.getTabCount()) {
            this.closeTabAt(0);
        }
        this._tabbedExecutionsPanel.addTab(tab.getTitle(), null, tab, tab.getToolTip());
        this._tabbedExecutionsPanel.setSelectedComponent(tab);
    }

    private void onPropertyChange(String propertyName) {
        if (propertyName.equals("sqlExecutionTabPlacement")) {
            this._tabbedExecutionsPanel.setTabPlacement(this._session.getProperties().getSQLExecutionTabPlacement());
        }
    }

    private void initTabPopup() {
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem close = new JMenuItem(i18n.CLOSE);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplainExecuterPanel.this._tabbedExecutionsPanel.remove(ExplainExecuterPanel.this._tabbedExecutionsPanel.getSelectedIndex());
            }
        });
        popup.add(close);
        JMenuItem closeAllButThis = new JMenuItem(i18n.CLOSE_ALL_BUT_THIS);
        closeAllButThis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Component c : ExplainExecuterPanel.this._tabbedExecutionsPanel.getComponents()) {
                    if (c == ExplainExecuterPanel.this._tabbedExecutionsPanel.getSelectedComponent()) continue;
                    ExplainExecuterPanel.this._tabbedExecutionsPanel.remove(c);
                }
            }
        });
        popup.add(closeAllButThis);
        JMenuItem closeAll = new JMenuItem(i18n.CLOSE_ALL);
        closeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplainExecuterPanel.this._tabbedExecutionsPanel.removeAll();
            }
        });
        popup.add(closeAll);
        this._tabbedExecutionsPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ExplainExecuterPanel.this.showPopup(e, popup);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ExplainExecuterPanel.this.showPopup(e, popup);
            }
        });
    }

    private void showPopup(MouseEvent e, JPopupMenu popup) {
        int index;
        if (e.isPopupTrigger() && -1 != (index = this._tabbedExecutionsPanel.getUI().tabForCoordinate(this._tabbedExecutionsPanel, e.getX(), e.getY()))) {
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void reRunTab(ExplainTab tab) {
        try {
            SQLExecuterTask executer = new SQLExecuterTask(this._session, this.getExplainSql(tab.getQuery()), (ISQLExecuterHandler)new SQLExecutionHandler(tab));
            this._session.getApplication().getThreadPool().addTask((Runnable)executer);
        }
        catch (UnsupportedStatementException e) {
            throw new IllegalStateException("It should be impossible that an UnsupportedStatementException is thrown on a re-run.");
        }
    }

    public String getTitle() {
        return i18n.TITLE;
    }

    public JComponent getComponent() {
        return this;
    }

    public IResultTab getSelectedResultTab() {
        throw new UnsupportedOperationException("ExplainExecuter has no ResultTabs");
    }

    private class SQLExecutionHandler
    implements ISQLExecuterHandler {
        ExplainTab _tabToReplace;

        public SQLExecutionHandler() {
        }

        public SQLExecutionHandler(ExplainTab tabToReplace) {
            this._tabToReplace = tabToReplace;
        }

        public void sqlToBeExecuted(String sql) {
        }

        public void sqlExecutionComplete(SQLExecutionInfo exInfo, int processedStatementCount, int statementCount) {
            double executionLength = (double)exInfo.getSQLExecutionElapsedMillis() / 1000.0;
            double outputLength = (double)exInfo.getResultsProcessingElapsedMillis() / 1000.0;
            double totalLength = executionLength + outputLength;
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            Object[] args = new Object[]{processedStatementCount, statementCount, numberFormat.format(totalLength), numberFormat.format(executionLength), numberFormat.format(outputLength)};
            ExplainExecuterPanel.this._session.showMessage(s_stringMgr.getString("ExplainExecuterPanel.queryStatistics", args));
        }

        public void sqlExecutionCancelled() {
        }

        public void sqlDataUpdated(int updateCount) {
        }

        public void sqlResultSetAvailable(ResultSet rs, SQLExecutionInfo info, IDataSetUpdateableTableModel model) throws DataSetException {
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, ExplainExecuterPanel.this._dialectType);
            if (this._tabToReplace != null) {
                this._tabToReplace.reInit(rsds, info, model);
            } else {
                ExplainExecuterPanel.this.addExplainTab(rsds, info, model);
            }
        }

        public void sqlExecutionWarning(SQLWarning warn) {
            ExplainExecuterPanel.this._session.showMessage((Throwable)warn);
        }

        public void sqlStatementCount(int statementCount) {
        }

        public String sqlExecutionException(Throwable th, String postErrorString) {
            String message = ExplainExecuterPanel.this._session.formatException((Throwable)new SQLExecutionException(th, postErrorString));
            ExplainExecuterPanel.this._session.showErrorMessage(message);
            if (ExplainExecuterPanel.this._session.getProperties().getWriteSQLErrorsToLog()) {
                s_log.info((Object)message);
            }
            return message;
        }

        public void sqlCloseExecutionHandler(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
        }
    }

    private class UnsupportedStatementException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UnsupportedStatementException() {
        }
    }

    static interface i18n {
        public static final String TITLE = ExplainExecuterPanel.access$000().getString("ExplainExecuterPanel.title");
        public static final String ONLY_SELECT_ALLOWED = ExplainExecuterPanel.access$000().getString("ExplainExecuterPanel.onlySelectAllowed");
        public static final String CLOSE = ExplainExecuterPanel.access$000().getString("ExplainExecuterPanel.close");
        public static final String CLOSE_ALL_BUT_THIS = ExplainExecuterPanel.access$000().getString("ExplainExecuterPanel.closeAllButThis");
        public static final String CLOSE_ALL = ExplainExecuterPanel.access$000().getString("ExplainExecuterPanel.closeAll");
        public static final String EXPLAIN_SQL_PREFIX = ExplainExecuterPanel.access$000().getString("Explain.sqlPrefix") + " ";
    }
}

