/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.commands;

import java.awt.Component;
import java.sql.SQLWarning;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.postgres.commands.AbstractPostgresDialogCommand;
import net.sourceforge.squirrel_sql.plugins.postgres.commands.handler.MessageSQLExecuterHandler;
import net.sourceforge.squirrel_sql.plugins.postgres.gui.MessageDialog;
import net.sourceforge.squirrel_sql.plugins.postgres.gui.VacuumDatabaseDialog;

public class VacuumDatabaseCommand
extends AbstractPostgresDialogCommand {
    protected VacuumDatabaseDialog _mainDialog;
    private static final ILogger s_log = LoggerController.createLogger(VacuumDatabaseCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(VacuumDatabaseCommand.class);

    public VacuumDatabaseCommand(ISession session) {
        super(session);
    }

    public void execute() throws BaseException {
        this.showDialog();
    }

    protected void showDialog() {
        String[] catalogs = this._session.getSchemaInfo().getCatalogs();
        String catalog = "";
        if (catalogs != null && catalogs.length > 0) {
            catalog = catalogs[0];
        }
        this._mainDialog = new VacuumDatabaseDialog(catalog);
        this._mainDialog.addExecuteListener(new AbstractPostgresDialogCommand.ExecuteListener(this));
        this._mainDialog.addEditSQLListener(new AbstractPostgresDialogCommand.EditSQLListener(this, this._mainDialog));
        this._mainDialog.addShowSQLListener(new AbstractPostgresDialogCommand.ShowSQLListener(this, i18n.SHOWSQL_DIALOG_TITLE, this._mainDialog));
        this._mainDialog.setLocationRelativeTo((Component)this._session.getApplication().getMainFrame());
        this._mainDialog.setVisible(true);
    }

    @Override
    protected String[] generateSQLStatements() {
        ArrayList<String> result = new ArrayList<String>();
        String sep = this._session.getQueryTokenizer().getSQLStatementSeparator();
        String full = this._mainDialog.getFullOption() ? "FULL " : "";
        String analyze = this._mainDialog.getAnalyzeOption() ? "ANALYZE " : "";
        StringBuilder stmt = new StringBuilder();
        stmt.append("VACUUM ").append(full).append("VERBOSE ").append(analyze);
        if (stmt.length() > 0) {
            stmt.append(sep);
            result.add(stmt.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected void executeScript(String script) {
        final MessageDialog messageDialog = new MessageDialog();
        messageDialog.setTitle("SQL Execution Output");
        messageDialog.setLocationRelativeTo((Component)this._session.getApplication().getMainFrame());
        VacuumDatabaseSQLExecuterHandler handler = new VacuumDatabaseSQLExecuterHandler(this._session, messageDialog, i18n.PROGRESS_DIALOG_TITLE, i18n.COMMAND_PREFIX);
        final SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.setSchemaCheck(false);
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VacuumDatabaseCommand.this._mainDialog.setVisible(false);
                        messageDialog.setVisible(true);
                    }
                });
                executer.run();
            }
        });
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class VacuumDatabaseSQLExecuterHandler
    extends MessageSQLExecuterHandler {
        public VacuumDatabaseSQLExecuterHandler(ISession session, MessageDialog mdialog, String progressDialogTitle, String commandPrefix) {
            super(session, mdialog, progressDialogTitle, commandPrefix);
        }

        @Override
        protected String getSuffix(String sql) {
            return i18n.COMMAND_SUFFIX;
        }

        @Override
        public void sqlExecutionWarning(SQLWarning warn) {
            String warning = warn.toString();
            if (warning.contains("INFO: vacuuming ")) {
                this._mdialog.writeEmptyLine();
                String tablename = warning.substring("INFO: vacuuming \"".length(), warning.length() - 1);
                this._mdialog.writeLine("======= " + this._commandPrefix + " " + tablename + " =======");
            }
            super.sqlExecutionWarning(warn);
        }
    }

    protected static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = VacuumDatabaseCommand.access$000().getString("VacuumDatabaseCommand.sqlDialogTitle");
        public static final String PROGRESS_DIALOG_TITLE = VacuumDatabaseCommand.access$000().getString("VacuumDatabaseCommand.progressDialogTitle");
        public static final String COMMAND_PREFIX = VacuumDatabaseCommand.access$000().getString("VacuumDatabaseCommand.commandPrefix");
        public static final String COMMAND_SUFFIX = VacuumDatabaseCommand.access$000().getString("VacuumDatabaseCommand.commandSuffix");
    }
}

