/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.commands;

import java.awt.Component;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.postgres.commands.AbstractPostgresDialogCommand;
import net.sourceforge.squirrel_sql.plugins.postgres.commands.handler.MessageSQLExecuterHandler;
import net.sourceforge.squirrel_sql.plugins.postgres.gui.MessageDialog;
import net.sourceforge.squirrel_sql.plugins.postgres.gui.VacuumTableDialog;

public class VacuumTableCommand
extends AbstractPostgresDialogCommand {
    protected VacuumTableDialog _mainDialog;
    protected final ITableInfo[] _infos;
    private static final ILogger s_log = LoggerController.createLogger(VacuumTableCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(VacuumTableCommand.class);

    public VacuumTableCommand(ISession session, IDatabaseObjectInfo[] infos) {
        super(session);
        ITableInfo[] tableinfos = new ITableInfo[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            if (!(infos[i] instanceof ITableInfo)) {
                throw new IllegalArgumentException("Not all selected objects where tables.");
            }
            tableinfos[i] = (ITableInfo)infos[i];
        }
        this._infos = tableinfos;
    }

    public void execute() throws BaseException {
        this.showDialog(this._infos);
    }

    protected void showDialog(ITableInfo[] tableinfos) {
        this._mainDialog = new VacuumTableDialog(tableinfos);
        this._mainDialog.addExecuteListener(new AbstractPostgresDialogCommand.ExecuteListener(this));
        this._mainDialog.addEditSQLListener(new AbstractPostgresDialogCommand.EditSQLListener(this, this._mainDialog));
        this._mainDialog.addShowSQLListener(new AbstractPostgresDialogCommand.ShowSQLListener(this, i18n.SHOWSQL_DIALOG_TITLE, this._mainDialog));
        this._mainDialog.setLocationRelativeTo((Component)this._session.getApplication().getMainFrame());
        this._mainDialog.setVisible(true);
    }

    @Override
    protected String[] generateSQLStatements() {
        ArrayList<String> result = new ArrayList<String>();
        String sep = this._session.getQueryTokenizer().getSQLStatementSeparator();
        String full = this._mainDialog.getFullOption() ? "FULL " : "";
        String analyze = this._mainDialog.getAnalyzeOption() ? "ANALYZE " : "";
        for (ITableInfo info : this._mainDialog.getContent()) {
            StringBuilder stmt = new StringBuilder();
            stmt.append("VACUUM ").append(full).append("VERBOSE ").append(analyze).append(info.getQualifiedName());
            if (stmt.length() <= 0) continue;
            stmt.append(sep);
            result.add(stmt.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected void executeScript(String script) {
        final MessageDialog messageDialog = new MessageDialog();
        messageDialog.setTitle("SQL Execution Output");
        messageDialog.setLocationRelativeTo((Component)this._session.getApplication().getMainFrame());
        VacuumTableSQLExecuterHandler handler = new VacuumTableSQLExecuterHandler(this._session, messageDialog, i18n.PROGRESS_DIALOG_TITLE, i18n.COMMAND_PREFIX);
        final SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.setSchemaCheck(false);
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VacuumTableCommand.this._mainDialog.setVisible(false);
                        messageDialog.setVisible(true);
                    }
                });
                executer.run();
            }
        });
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class VacuumTableSQLExecuterHandler
    extends MessageSQLExecuterHandler {
        public VacuumTableSQLExecuterHandler(ISession session, MessageDialog mdialog, String progressDialogTitle, String commandPrefix) {
            super(session, mdialog, progressDialogTitle, commandPrefix);
        }

        @Override
        protected String getSuffix(String sql) {
            String[] parts = sql.split(" ");
            return parts[parts.length - 1];
        }
    }

    protected static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = VacuumTableCommand.access$000().getString("VacuumTableCommand.sqlDialogTitle");
        public static final String PROGRESS_DIALOG_TITLE = VacuumTableCommand.access$000().getString("VacuumTableCommand.progressDialogTitle");
        public static final String COMMAND_PREFIX = VacuumTableCommand.access$000().getString("VacuumTableCommand.commandPrefix");
    }
}

