/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.prefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PreferenceUtil;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.sqlscript.prefs.SQLScriptPreferenceBean;

public class SQLScriptPreferencesManager {
    private static final ILogger s_log = LoggerController.createLogger(SQLScriptPreferencesManager.class);
    private static final String USER_PREFS_FILE_NAME = "prefs.xml";
    private static File _userSettingsFolder;
    private static SQLScriptPreferenceBean _prefs;
    private static IPlugin plugin;

    public static void initialize(IPlugin thePlugin) throws PluginException {
        plugin = thePlugin;
        try {
            _userSettingsFolder = plugin.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        SQLScriptPreferencesManager.loadPrefs();
    }

    public static SQLScriptPreferenceBean getPreferences() {
        return _prefs;
    }

    public static void unload() {
        SQLScriptPreferencesManager.savePrefs();
    }

    public static void savePrefs() {
        try {
            XMLBeanWriter wtr = new XMLBeanWriter((Object)_prefs);
            wtr.save(new File(_userSettingsFolder, USER_PREFS_FILE_NAME));
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occured writing to preferences file: prefs.xml", (Throwable)ex);
        }
    }

    private static void loadPrefs() {
        try {
            XMLBeanReader doc = new XMLBeanReader();
            File prefFile = PreferenceUtil.getPreferenceFileToReadFrom((IPlugin)plugin);
            doc.load(prefFile, SQLScriptPreferenceBean.class.getClassLoader());
            Iterator it = doc.iterator();
            if (it.hasNext()) {
                _prefs = (SQLScriptPreferenceBean)it.next();
            }
        }
        catch (FileNotFoundException ignore) {
            s_log.info((Object)"prefs.xml not found - will be created");
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occured reading from preferences file: prefs.xml", (Throwable)ex);
        }
        if (_prefs == null) {
            _prefs = new SQLScriptPreferenceBean();
        }
        _prefs.setClientName(Version.getApplicationName() + "/" + plugin.getDescriptiveName());
        _prefs.setClientVersion(Version.getShortVersion() + "/" + plugin.getVersion());
    }

    static {
        _prefs = null;
        plugin = null;
    }
}

