/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import java.awt.event.WindowAdapter;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.plugins.sqlscript.SQLScriptPlugin;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDataScriptCommand
extends WindowAdapter
implements ICommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractDataScriptCommand.class);
    private final ISession session;
    private final SQLScriptPlugin plugin;

    public AbstractDataScriptCommand(ISession session, SQLScriptPlugin plugin) {
        this.session = session;
        this.plugin = plugin;
    }

    public ISession getSession() {
        return this.session;
    }

    public SQLScriptPlugin getPlugin() {
        return this.plugin;
    }

    protected String getSelectedSelectStatement() {
        String currentSQL;
        ISQLPanelAPI api = FrameWorkAcessor.getSQLPanelAPI(this.getSession(), this.getPlugin());
        String script = api.getSQLScriptToBeExecuted();
        IQueryTokenizer qt = this.getSession().getQueryTokenizer();
        qt.setScriptToTokenize(script);
        if (!qt.hasQuery()) {
            this.getSession().showErrorMessage(s_stringMgr.getString("AbstractDataScriptCommand.noQuery"));
            return null;
        }
        if (qt.getQueryCount() > 1) {
            this.getSession().showWarningMessage(s_stringMgr.getString("AbstractDataScriptCommand.moreThanOnQuery"));
        }
        if (!StringUtils.startsWithIgnoreCase((String)(currentSQL = qt.nextQuery()), (String)"select")) {
            this.getSession().showErrorMessage(s_stringMgr.getString("AbstractDataScriptCommand.notASelect"));
            return null;
        }
        return currentSQL;
    }
}

