/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;

public class AutoCorrector {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AutoCorrector.class);
    private JTextComponent _txtComp;
    private SyntaxPlugin _plugin;
    private int _autocorrectionsCount = 0;
    private static final String PREFS_KEY_AUTO_COORECTIONS_COUNT = "squirrelSql_syntax_autocorrections_count";

    public AutoCorrector(JTextComponent txtComp, SyntaxPlugin plugin) {
        this._txtComp = txtComp;
        this._plugin = plugin;
        this._txtComp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AutoCorrector.this.onInsertUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }
        });
        this._autocorrectionsCount = Preferences.userRoot().getInt(PREFS_KEY_AUTO_COORECTIONS_COUNT, 0);
    }

    private void onInsertUpdate(DocumentEvent e) {
        try {
            if (1 != e.getLength()) {
                return;
            }
            final String insertChar = e.getDocument().getText(e.getOffset(), 1);
            if (' ' == insertChar.charAt(0)) {
                String autoCorrCandidate = this.getStringBeforeWhiteSpace(e.getOffset()).toUpperCase();
                final String corr = this._plugin.getAutoCorrectProviderImpl().getAutoCorrects().get(autoCorrCandidate);
                if (null != corr) {
                    this._txtComp.setSelectionStart(e.getOffset() - autoCorrCandidate.length());
                    this._txtComp.setSelectionEnd(e.getOffset());
                    if (10 > this._autocorrectionsCount) {
                        String[] params = new String[]{autoCorrCandidate, corr};
                        this._plugin.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("syntax.hasBeenAutocorr", params));
                        Preferences.userRoot().putInt(PREFS_KEY_AUTO_COORECTIONS_COUNT, ++this._autocorrectionsCount);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoCorrector.this._txtComp.replaceSelection(corr + insertChar);
                        }
                    });
                }
            }
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getStringBeforeWhiteSpace(int offset) {
        try {
            String text = this._txtComp.getDocument().getText(0, offset);
            String ret = null;
            int begPos = text.length();
            for (int i = text.length() - 1; 0 <= i && !Character.isWhitespace(text.charAt(i)); --i) {
                --begPos;
            }
            ret = text.substring(begPos, text.length());
            return ret;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }
}

