/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.prefspanel;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPluginResources;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxStyle;
import net.sourceforge.squirrel_sql.plugins.syntax.prefspanel.StylesList;

public class StyleMaintenancePanel
extends JToolBar {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(StyleMaintenancePanel.class);
    private final StylesList _list;
    private final JToggleButton _boldChk;
    private final JToggleButton _italicChk;
    private final JButton _fontColorBtn;
    private final JButton _backgroundColorBtn;
    private FontColorButtonListener _fontColorBtnLis;
    private BackgroundColorButtonListener _backgroundColorBtnLis;
    private ActionListener _toggleLis;
    private SyntaxStyle _style;

    public StyleMaintenancePanel(StylesList list, SyntaxPluginResources rsrc) {
        this._list = list;
        this.setFloatable(false);
        this._boldChk = new JToggleButton(rsrc.getIcon("Bold"));
        this._boldChk.setToolTipText(s_stringMgr.getString("syntax.bold"));
        this._italicChk = new JToggleButton(rsrc.getIcon("Italic"));
        this._italicChk.setToolTipText(s_stringMgr.getString("syntax.italic"));
        this._fontColorBtn = new JButton(rsrc.getIcon("Foreground"));
        this._fontColorBtn.setToolTipText(s_stringMgr.getString("syntax.font"));
        this._backgroundColorBtn = new JButton(rsrc.getIcon("Background"));
        this._backgroundColorBtn.setToolTipText(s_stringMgr.getString("syntax.background"));
        this.add(this._boldChk);
        this.add(this._italicChk);
        this.add(this._fontColorBtn);
        this.add(this._backgroundColorBtn);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._fontColorBtnLis == null) {
            this._fontColorBtnLis = new FontColorButtonListener(this._list);
            this._fontColorBtn.addActionListener(this._fontColorBtnLis);
            this._backgroundColorBtnLis = new BackgroundColorButtonListener(this._list);
            this._backgroundColorBtn.addActionListener(this._backgroundColorBtnLis);
        }
        if (this._toggleLis == null) {
            this._toggleLis = new ToggleButtonListener();
            this._boldChk.addActionListener(this._toggleLis);
            this._italicChk.addActionListener(this._toggleLis);
        }
    }

    @Override
    public void removeNotify() {
        if (this._fontColorBtnLis != null) {
            this._fontColorBtn.removeActionListener(this._fontColorBtnLis);
            this._backgroundColorBtn.removeActionListener(this._backgroundColorBtnLis);
            this._fontColorBtnLis = null;
            this._backgroundColorBtnLis = null;
        }
        if (this._toggleLis != null) {
            this._boldChk.removeActionListener(this._toggleLis);
            this._italicChk.removeActionListener(this._toggleLis);
            this._toggleLis = null;
        }
        super.removeNotify();
    }

    @Override
    public void setEnabled(boolean enable) {
        this._boldChk.setEnabled(enable);
        this._italicChk.setEnabled(enable);
        this._fontColorBtn.setEnabled(enable);
        this._backgroundColorBtn.setEnabled(enable);
    }

    public void setStyle(SyntaxStyle style) {
        this._boldChk.setSelected(style.isBold());
        this._italicChk.setSelected(style.isItalic());
        this._style = style;
    }

    private static class BackgroundColorButtonListener
    implements ActionListener {
        private final StylesList _list;

        BackgroundColorButtonListener(StylesList list) {
            this._list = list;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SyntaxStyle style = this._list.getSelectedSyntaxStyle();
            int origRGB = style.getBackgroundRGB();
            Color color = JColorChooser.showDialog(null, s_stringMgr.getString("syntax.selColor2"), new Color(origRGB));
            if (color != null) {
                style.setBackgroundRGB(color.getRGB());
            }
        }
    }

    private static class FontColorButtonListener
    implements ActionListener {
        private final StylesList _list;

        FontColorButtonListener(StylesList list) {
            this._list = list;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SyntaxStyle style = this._list.getSelectedSyntaxStyle();
            int origRGB = style.getTextRGB();
            Color color = JColorChooser.showDialog(null, s_stringMgr.getString("syntax.selColor"), new Color(origRGB));
            if (color != null) {
                style.setTextRGB(color.getRGB());
            }
        }
    }

    private final class ToggleButtonListener
    implements ActionListener {
        private ToggleButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            StyleMaintenancePanel.this._style.setBold(StyleMaintenancePanel.this._boldChk.isSelected());
            StyleMaintenancePanel.this._style.setItalic(StyleMaintenancePanel.this._italicChk.isSelected());
            StyleMaintenancePanel.this._list.repaint();
        }
    }
}

