/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IUndoHandler;
import net.sourceforge.squirrel_sql.client.session.parser.IParserEventsProcessor;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsAdapter;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorInfo;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.KeyManager;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPreferences;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxHighlightTokenMatcherProxy;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.RSyntaxPropertiesWrapper;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirreLRSyntaxTextAreaUI;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelSyntaxScheme;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelTokenMarkerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.SquirrelRSyntaxSearchEngine;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

public class SquirrelRSyntaxTextArea
extends RSyntaxTextArea {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SquirrelRSyntaxTextArea.class);
    private ISession _session;
    private SyntaxPreferences _prefs;
    private RSyntaxPropertiesWrapper _propertiesWrapper;
    private IIdentifier _sqlEntryPanelIdentifier;
    private RSyntaxHighlightTokenMatcherProxy _rSyntaxHighlightTokenMatcherProxy;
    private IUndoHandler _undoHandler;
    private SquirrelSyntaxScheme _squirrelSyntaxScheme;
    private ErrorInfo[] _currentErrorInfos = new ErrorInfo[0];
    private boolean _parsingInitialized;
    private SquirrelRSyntaxSearchEngine _squirrelRSyntaxSearchEngine;

    public SquirrelRSyntaxTextArea(ISession session, SyntaxPreferences prefs, RSyntaxPropertiesWrapper propertiesWrapper, IIdentifier sqlEntryPanelIdentifier) {
        this._session = session;
        this._prefs = prefs;
        this._propertiesWrapper = propertiesWrapper;
        this._sqlEntryPanelIdentifier = sqlEntryPanelIdentifier;
        this._rSyntaxHighlightTokenMatcherProxy.setDelegate(this._propertiesWrapper.getSyntaxHighlightTokenMatcher(session, this, sqlEntryPanelIdentifier));
        this.modifiyKeystrokesFromPreferences(prefs);
        this.updateFromPreferences();
        new KeyManager((JTextComponent)((Object)this));
        this._squirrelRSyntaxSearchEngine = new SquirrelRSyntaxSearchEngine(this._session, this);
        this.setToolTipText("Just to make getToolTiptext() to be called");
        this.setMarginLineEnabled(prefs.isTextLimitLineVisible());
        this.setMarginLinePosition(prefs.getTextLimitLineWidth());
        this.setHighlightCurrentLine(prefs.isHighlightCurrentLine());
        if (null != System.getProperty("os.name") && System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") && (null == System.getProperty("sun.java2d.noddraw") || !"true".equals(System.getProperty("sun.java2d.noddraw")))) {
            session.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("syntax.useNoDDrawOnWIn32"));
        }
    }

    private void modifiyKeystrokesFromPreferences(SyntaxPreferences prefs) {
        InputMap shared = this.getInputMap();
        if (prefs.isUseCopyAsRtf()) {
            KeyStroke[] allKeys;
            for (KeyStroke keyStroke : allKeys = shared.allKeys()) {
                Object object = shared.get(keyStroke);
                if (!"copy-to-clipboard".equals(object)) continue;
                shared.put(keyStroke, "RSTA.CopyAsRtfAction");
            }
        }
    }

    protected RTextAreaUI createRTextAreaUI() {
        SquirreLRSyntaxTextAreaUI ret = new SquirreLRSyntaxTextAreaUI(this);
        this._undoHandler = ret.createUndoHandler();
        return ret;
    }

    protected JPopupMenu createPopupMenu() {
        return null;
    }

    protected Document createDefaultModel() {
        this._rSyntaxHighlightTokenMatcherProxy = new RSyntaxHighlightTokenMatcherProxy();
        RSyntaxDocument ret = new RSyntaxDocument((TokenMakerFactory)new SquirrelTokenMarkerFactory(this, this._rSyntaxHighlightTokenMatcherProxy), "text/sql");
        return ret;
    }

    public SyntaxScheme getDefaultSyntaxScheme() {
        this._squirrelSyntaxScheme = new SquirrelSyntaxScheme();
        return this._squirrelSyntaxScheme;
    }

    public IUndoHandler createUndoHandler() {
        return this._undoHandler;
    }

    public void addUndoableEditListener(UndoableEditListener um) {
        this.getDocument().addUndoableEditListener(um);
    }

    public void updateFromPreferences() {
        this.setFont(this._session.getProperties().getFontInfo().createFont());
        this._squirrelSyntaxScheme.initSytles(this._prefs, this._session.getProperties().getFontInfo());
        new RSyntaxTextAreaEditorKit.IncreaseFontSizeAction().actionPerformedImpl(new ActionEvent((Object)this, 1, "foo"), (RTextArea)this);
        new RSyntaxTextAreaEditorKit.DecreaseFontSizeAction().actionPerformedImpl(new ActionEvent((Object)this, 1, "bar"), (RTextArea)this);
        this.repaint();
    }

    public void addSQLTokenListeners(ISession session, SQLTokenListener tl) {
        this._rSyntaxHighlightTokenMatcherProxy.addSQLTokenListener(tl);
    }

    public void removeSQLTokenListeners(ISession session, SQLTokenListener tl) {
        this._rSyntaxHighlightTokenMatcherProxy.removeSQLTokenListener(tl);
    }

    public String getToolTipText(MouseEvent event) {
        int pos = this.viewToModel(event.getPoint());
        this.initParsing();
        for (int i = 0; i < this._currentErrorInfos.length; ++i) {
            if (this._currentErrorInfos[i].beginPos - 1 > pos || pos > this._currentErrorInfos[i].endPos) continue;
            return this._currentErrorInfos[i].message;
        }
        return null;
    }

    private void initParsing() {
        IParserEventsProcessor parserEventsProcessor = this._propertiesWrapper.getParserEventsProcessor(this._sqlEntryPanelIdentifier, this._session);
        if (!this._parsingInitialized && null != parserEventsProcessor) {
            this._parsingInitialized = true;
            parserEventsProcessor.addParserEventsListener((ParserEventsListener)new ParserEventsAdapter(){

                public void errorsFound(ErrorInfo[] errorInfos) {
                    SquirrelRSyntaxTextArea.this.onErrorsFound(errorInfos);
                }
            });
        }
    }

    private void onErrorsFound(ErrorInfo[] errorInfos) {
        this._currentErrorInfos = errorInfos;
    }

    public void showFindDialog(ActionEvent evt) {
        this._squirrelRSyntaxSearchEngine.find(evt);
    }

    public void findSelected(ActionEvent evt) {
        this._squirrelRSyntaxSearchEngine.findSelected(evt);
    }

    public void repeatLastFind(ActionEvent evt) {
        this._squirrelRSyntaxSearchEngine.repeatLastFind(evt);
    }

    public void markSelected(ActionEvent evt) {
        this._squirrelRSyntaxSearchEngine.markSelected(evt);
    }

    public void unmarkAll() {
        this._squirrelRSyntaxSearchEngine.unmarkAll();
    }

    public void showReplaceDialog(ActionEvent evt) {
        this._squirrelRSyntaxSearchEngine.replace(evt);
    }

    public void showGoToLineDialog(ActionEvent evt) {
        this._squirrelRSyntaxSearchEngine.goToLine();
    }

    public void sessionEnding() {
        this.getCaret().deinstall((JTextComponent)((Object)this));
        if (this.getCaret() instanceof DefaultCaret) {
            ChangeListener[] changeListeners;
            for (ChangeListener changeListener : changeListeners = ((DefaultCaret)this.getCaret()).getChangeListeners()) {
                this.getCaret().removeChangeListener(changeListener);
            }
        }
    }
}

