/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.CaretState;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.ISquirrelSearchDialog;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.SearchDialogClosingListener;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.SearchDialogState;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.SquirrelFindDialog;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.SquirrelGoToDialog;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.SquirrelReplaceDialog;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchEngine;

public class SquirrelRSyntaxSearchEngine {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SquirrelRSyntaxSearchEngine.class);
    private ISession _session;
    private SquirrelRSyntaxTextArea _squirrelRSyntaxTextArea;
    private ISquirrelSearchDialog _dialog;
    private boolean _foundAtLeastOne;
    private String _lastSearchString;
    private CaretState _storedCaretState;
    private SearchDialogState _storedSearchDialogState;

    public SquirrelRSyntaxSearchEngine(ISession session, SquirrelRSyntaxTextArea squirrelRSyntaxTextArea) {
        this._session = session;
        this._squirrelRSyntaxTextArea = squirrelRSyntaxTextArea;
    }

    public void find(ActionEvent squirrelEvt) {
        this._session.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("SquirrelRSyntaxSearchEngine.findUsageHint"));
        this.search(squirrelEvt, false);
    }

    public void replace(ActionEvent squirrelEvt) {
        this.search(squirrelEvt, true);
    }

    public void search(ActionEvent squirrelEvt, boolean replace) {
        if (null != this._dialog) {
            this._dialog.requestFocus();
            return;
        }
        this._dialog = replace ? new SquirrelReplaceDialog(this._session.getApplication().getMainFrame()) : new SquirrelFindDialog(this._session.getApplication().getMainFrame());
        this._dialog.addFindActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SquirrelRSyntaxSearchEngine.this.onFind();
            }
        });
        this._dialog.addReplaceActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SquirrelRSyntaxSearchEngine.this.onReplace();
            }
        });
        this._dialog.addReplaceAllActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SquirrelRSyntaxSearchEngine.this.onReplaceAll();
            }
        });
        Vector<String> comboBoxStrings = new Vector<String>();
        if (null != this._lastSearchString) {
            comboBoxStrings.add(this._lastSearchString);
        }
        this._dialog.setSearchParameters(comboBoxStrings, false, false, false, false, false);
        String selectedText = this._squirrelRSyntaxTextArea.getSelectedText();
        if (null != selectedText) {
            this._dialog.setSearchString(selectedText);
        }
        this._dialog.setVisible(true);
        this._dialog.addClosingListener(new SearchDialogClosingListener(){

            @Override
            public void searchDialogClosing() {
                SquirrelRSyntaxSearchEngine.this.onDialogClosing();
            }
        });
        this.storeCaretState();
        this._foundAtLeastOne = false;
    }

    private void onReplaceAll() {
        this._lastSearchString = this._dialog.getSearchString();
        int count = SearchEngine.replaceAll((RTextArea)this._squirrelRSyntaxTextArea, (String)this._lastSearchString, (String)this._dialog.getReplaceString(), (boolean)this._dialog.isMatchCase(), (boolean)this._dialog.isWholeWord(), (boolean)this._dialog.isRegExp());
        if (this._dialog.isMarkAll() && null != this._dialog.getReplaceString() && 0 < this._dialog.getReplaceString().length()) {
            this.invokeMarkAllForReplaceLater();
        }
        this._session.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.countOccurencesReplaced", new Object[]{count}));
    }

    private void onReplace() {
        try {
            this._lastSearchString = this._dialog.getSearchString();
            boolean found = SearchEngine.replace((RTextArea)this._squirrelRSyntaxTextArea, (String)this._lastSearchString, (String)this._dialog.getReplaceString(), (!this._dialog.isSearchUp() ? 1 : 0) != 0, (boolean)this._dialog.isMatchCase(), (boolean)this._dialog.isWholeWord(), (boolean)this._dialog.isRegExp());
            if (this._dialog.isMarkAll() && null != this._dialog.getReplaceString() && 0 < this._dialog.getReplaceString().length()) {
                this.invokeMarkAllForReplaceLater();
            }
            if (!found) {
                String msg = s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.noMatchRestart");
                if (0 == JOptionPane.showConfirmDialog(this._dialog.getDialog(), msg)) {
                    if (this._dialog.isSearchUp()) {
                        this._squirrelRSyntaxTextArea.setCaretPosition(this._squirrelRSyntaxTextArea.getText().length());
                    } else {
                        this._squirrelRSyntaxTextArea.setCaretPosition(0);
                    }
                    found = SearchEngine.replace((RTextArea)this._squirrelRSyntaxTextArea, (String)this._lastSearchString, (String)this._dialog.getReplaceString(), (!this._dialog.isSearchUp() ? 1 : 0) != 0, (boolean)this._dialog.isMatchCase(), (boolean)this._dialog.isWholeWord(), (boolean)this._dialog.isRegExp());
                    if (this._dialog.isMarkAll() && null != this._dialog.getReplaceString() && 0 < this._dialog.getReplaceString().length()) {
                        this.invokeMarkAllForReplaceLater();
                    }
                    if (!found) {
                        JOptionPane.showMessageDialog(this._dialog.getDialog(), s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.noMatch"));
                    } else {
                        this._foundAtLeastOne = true;
                    }
                }
            } else {
                this._foundAtLeastOne = true;
            }
        }
        catch (PatternSyntaxException pse) {
            String msg = s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.RegExErrMsg");
            String title = s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.RegExErrTitle", new Object[]{pse.toString()});
            JOptionPane.showMessageDialog(this._dialog.getDialog(), msg, title, 0);
        }
    }

    private void invokeMarkAllForReplaceLater() {
        this._squirrelRSyntaxTextArea.clearMarkAllHighlights();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SquirrelRSyntaxSearchEngine.this._squirrelRSyntaxTextArea.markAll(SquirrelRSyntaxSearchEngine.this._dialog.getReplaceString(), SquirrelRSyntaxSearchEngine.this._dialog.isMatchCase(), SquirrelRSyntaxSearchEngine.this._dialog.isWholeWord(), SquirrelRSyntaxSearchEngine.this._dialog.isRegExp());
            }
        });
    }

    private void storeCaretState() {
        this._storedCaretState = new CaretState(this._squirrelRSyntaxTextArea);
    }

    private void onDialogClosing() {
        this._storedSearchDialogState = new SearchDialogState(this._dialog);
        if (!this._foundAtLeastOne) {
            this._storedCaretState.restoreCaretState(this._squirrelRSyntaxTextArea);
        }
        this._dialog = null;
    }

    private void onFind() {
        try {
            boolean found;
            this._lastSearchString = this._dialog.getSearchString();
            if (this._dialog.isMarkAll()) {
                this._squirrelRSyntaxTextArea.markAll(this._lastSearchString, this._dialog.isMatchCase(), this._dialog.isWholeWord(), this._dialog.isRegExp());
            }
            if (!(found = SearchEngine.find((JTextArea)((Object)this._squirrelRSyntaxTextArea), (String)this._lastSearchString, (!this._dialog.isSearchUp() ? 1 : 0) != 0, (boolean)this._dialog.isMatchCase(), (boolean)this._dialog.isWholeWord(), (boolean)this._dialog.isRegExp()))) {
                String msg = s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.noMatchRestart");
                if (0 == JOptionPane.showConfirmDialog(this._dialog.getDialog(), msg)) {
                    if (this._dialog.isSearchUp()) {
                        this._squirrelRSyntaxTextArea.setCaretPosition(this._squirrelRSyntaxTextArea.getText().length());
                    } else {
                        this._squirrelRSyntaxTextArea.setCaretPosition(0);
                    }
                    found = SearchEngine.find((JTextArea)((Object)this._squirrelRSyntaxTextArea), (String)this._lastSearchString, (!this._dialog.isSearchUp() ? 1 : 0) != 0, (boolean)this._dialog.isMatchCase(), (boolean)this._dialog.isWholeWord(), (boolean)this._dialog.isRegExp());
                    if (!found) {
                        JOptionPane.showMessageDialog(this._dialog.getDialog(), s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.noMatch"));
                    } else {
                        this._foundAtLeastOne = true;
                    }
                }
            } else {
                this._foundAtLeastOne = true;
            }
        }
        catch (PatternSyntaxException pse) {
            String msg = s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.RegExErrMsg");
            String title = s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.RegExErrTitle", new Object[]{pse.toString()});
            JOptionPane.showMessageDialog(this._dialog.getDialog(), msg, title, 0);
        }
    }

    public void findSelected(ActionEvent evt) {
        String selectedText = this._squirrelRSyntaxTextArea.getSelectedText();
        if (null == selectedText || 0 == selectedText.length()) {
            return;
        }
        this._lastSearchString = selectedText;
        this._storedSearchDialogState = SearchDialogState.createForLastFind();
        this._repeatLastFind(this._storedSearchDialogState);
    }

    private void _repeatLastFind(SearchDialogState searchDialogState) {
        boolean found = SearchEngine.find((JTextArea)((Object)this._squirrelRSyntaxTextArea), (String)this._lastSearchString, (!searchDialogState.isSearchUp() ? 1 : 0) != 0, (boolean)searchDialogState.isMatchCase(), (boolean)searchDialogState.isWholeWord(), (boolean)searchDialogState.isRegExp());
        if (!found) {
            this.storeCaretState();
            if (searchDialogState.isSearchUp()) {
                this._squirrelRSyntaxTextArea.setCaretPosition(this._squirrelRSyntaxTextArea.getText().length());
            } else {
                this._squirrelRSyntaxTextArea.setCaretPosition(0);
            }
            found = SearchEngine.find((JTextArea)((Object)this._squirrelRSyntaxTextArea), (String)this._lastSearchString, (!searchDialogState.isSearchUp() ? 1 : 0) != 0, (boolean)searchDialogState.isMatchCase(), (boolean)searchDialogState.isWholeWord(), (boolean)searchDialogState.isRegExp());
            if (!found) {
                this._storedCaretState.restoreCaretState(this._squirrelRSyntaxTextArea);
            }
        }
    }

    public void repeatLastFind(ActionEvent evt) {
        if (null == this._lastSearchString || 0 == this._lastSearchString.length() || null == this._storedSearchDialogState) {
            return;
        }
        this._repeatLastFind(this._storedSearchDialogState);
    }

    public void markSelected(ActionEvent evt) {
        String selectedText = this._squirrelRSyntaxTextArea.getSelectedText();
        if (null == selectedText || 0 == selectedText.length()) {
            return;
        }
        this._lastSearchString = selectedText;
        this._storedSearchDialogState = SearchDialogState.createForLastFind();
        this._squirrelRSyntaxTextArea.markAll(this._lastSearchString, this._storedSearchDialogState.isMatchCase(), this._storedSearchDialogState.isWholeWord(), this._storedSearchDialogState.isRegExp());
    }

    public void unmarkAll() {
        this._squirrelRSyntaxTextArea.clearMarkAllHighlights();
    }

    public void goToLine() {
        SquirrelGoToDialog squirrelGoToDialog = new SquirrelGoToDialog((JFrame)this._session.getApplication().getMainFrame());
        squirrelGoToDialog.setMaxLineNumberAllowed(this._squirrelRSyntaxTextArea.getLineCount());
        squirrelGoToDialog.setVisible(true);
        int lineNumber = squirrelGoToDialog.getLineNumber();
        if (lineNumber > 0) {
            try {
                this._squirrelRSyntaxTextArea.setCaretPosition(this._squirrelRSyntaxTextArea.getLineStartOffset(lineNumber - 1));
            }
            catch (BadLocationException ble) {
                JOptionPane.showMessageDialog((Component)this._session.getApplication().getMainFrame(), s_stringMgr.getString("syntax.SquirrelRSyntaxSearchEngine.InvalidLineNumber"));
            }
        }
    }
}

