/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.userscript.kernel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ScriptEnvironment {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ScriptEnvironment.class);
    private ISQLPanelAPI m_sqlPanelApi;
    private JFrame m_ownerFrame;
    private JDialog m_dlg;
    private JTabbedPane m_tabbedPane;
    private JLabel m_lblStatus;
    private Vector<PrintStream> m_printStreams = new Vector();
    private int createdPrintStreamsCount = 0;

    ScriptEnvironment(ISQLPanelAPI sqlPanelApi, JFrame ownerFrame) {
        this.m_sqlPanelApi = sqlPanelApi;
        this.m_ownerFrame = ownerFrame;
        this.m_dlg = new JDialog(this.m_ownerFrame, s_stringMgr.getString("userscript.execOutput"), false);
        this.m_dlg.getContentPane().setLayout(new BorderLayout());
        this.m_tabbedPane = new JTabbedPane();
        this.m_lblStatus = new JLabel(s_stringMgr.getString("userscript.executing"));
        this.m_dlg.getContentPane().add((Component)this.m_tabbedPane, "Center");
        this.m_dlg.getContentPane().add((Component)this.m_lblStatus, "South");
        GUIUtils.centerWithinParent((Window)this.m_dlg);
        this.m_dlg.setSize(400, 400);
    }

    public PrintStream createPrintStream() {
        return this.createPrintStream(null);
    }

    public PrintStream createPrintStream(String tabTitle) {
        final ByteArrayOutputStream bos = new ByteArrayOutputStream();
        final JTextArea txtOut = new JTextArea();
        if (null == tabTitle) {
            this.m_tabbedPane.addTab("<" + ++this.createdPrintStreamsCount + ">", txtOut);
        } else {
            this.m_tabbedPane.addTab(tabTitle, new JScrollPane(txtOut));
        }
        PrintStream ret = new PrintStream(bos){

            @Override
            public void flush() {
                super.flush();
                ScriptEnvironment.this.onFlush(bos, txtOut);
            }
        };
        this.m_dlg.setVisible(true);
        this.m_printStreams.add(ret);
        return ret;
    }

    private void onFlush(ByteArrayOutputStream bos, JTextArea txtOut) {
        txtOut.append(bos.toString());
        bos.reset();
    }

    public PrintStream getSQLAreaPrintStream() {
        final ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ret = new PrintStream(bos){

            @Override
            public void flush() {
                super.flush();
                ScriptEnvironment.this.onFlushToSqlArea(bos);
            }
        };
        this.m_printStreams.add(ret);
        return ret;
    }

    private void onFlushToSqlArea(ByteArrayOutputStream bos) {
        this.m_sqlPanelApi.appendSQLScript(bos.toString());
        bos.reset();
    }

    void flushAll() {
        for (int i = 0; i < this.m_printStreams.size(); ++i) {
            PrintStream printStream = this.m_printStreams.elementAt(i);
            printStream.flush();
        }
    }

    void setExecutionFinished(boolean successful) {
        if (successful) {
            this.m_lblStatus.setText(s_stringMgr.getString("userscript.scriptCompleted"));
        } else {
            this.m_lblStatus.setText(s_stringMgr.getString("userscript.scriptCompletedErr"));
        }
    }
}

