/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import de.tsl2.nano.collection.SegmentList;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrSegList<TARRAY, T>
implements List<T> {
    private static final long serialVersionUID = 8456729694923697194L;
    protected SegmentList<TARRAY, T> seg;
    int elements = 0;
    int arraysize = 0;
    protected int segmentation;

    public ArrSegList() {
        this(Object.class, 50, 50);
    }

    public ArrSegList(Class<T> type) {
        this(type, 50, 50);
    }

    public ArrSegList(Class<T> type, int segmentation, int capacity) {
        this.segmentation = segmentation;
        this.seg = new SegmentList(type, capacity);
    }

    @Override
    public T get(int index) {
        int iseg = index / this.segmentation;
        int iarr = index % this.segmentation;
        return (T)Array.get(this.seg.get(iseg), iarr);
    }

    public final TARRAY getLastSegment() {
        return (TARRAY)this.seg.get(this.seg.size() - 1);
    }

    @Override
    public boolean add(T newItem) {
        Object s;
        if (this.elements == this.arraysize) {
            s = this.seg.newArraySegment(this.segmentation);
            this.arraysize += this.segmentation;
            this.seg.add(s);
        } else {
            s = this.seg.get(this.seg.size() - 1);
        }
        Array.set(s, this.elements % this.segmentation, newItem);
        ++this.elements;
        return true;
    }

    public boolean addSegment(TARRAY newSegment) {
        int length = Array.getLength(newSegment);
        assert (length <= this.segmentation);
        if (length == this.segmentation) {
            if (this.elements == this.arraysize) {
                this.arraysize += this.segmentation;
                this.seg.add(newSegment);
            } else if (this.elements + length >= this.arraysize) {
                Object s = Array.get(this.seg, this.seg.size() - 1);
                int delta = this.elements + length - this.arraysize;
                System.arraycopy(newSegment, 0, s, this.elements % this.segmentation, delta);
                System.arraycopy(newSegment, delta + 1, newSegment, 0, delta);
                this.seg.add(newSegment);
            }
        } else if (this.elements + length < this.arraysize) {
            TARRAY s = this.getLastSegment();
            System.arraycopy(newSegment, 0, s, this.elements % this.segmentation, length);
        } else {
            TARRAY s = this.seg.newArraySegment(this.segmentation);
            this.arraysize += this.segmentation;
            System.arraycopy(newSegment, 0, s, this.elements % this.segmentation, length);
            this.seg.add(newSegment);
        }
        this.elements += length;
        return length == this.segmentation;
    }

    @Override
    public int size() {
        return this.elements;
    }

    public TARRAY toSegmentArray() {
        int c;
        TARRAY arr = this.seg.newArraySegment(this.elements);
        int size = this.seg.size();
        for (c = 0; c < size - 1; ++c) {
            System.arraycopy(this.seg.get(c), 0, arr, c * this.segmentation, this.segmentation);
        }
        if (size > 0) {
            int rest = this.elements - c * this.segmentation;
            System.arraycopy(this.seg.get(size - 1), 0, arr, c * this.segmentation, rest);
        }
        return arr;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.toSegmentArray();
    }

    @Override
    public boolean isEmpty() {
        return this.elements == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object item : c) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = true;
        for (T item : c) {
            result &= this.add(item);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public T set(int index, T element) {
        return null;
    }

    @Override
    public void add(int index, T element) {
    }

    @Override
    public T remove(int index) {
        return null;
    }

    @Override
    public int indexOf(Object o) {
        for (Object arr : this.seg) {
            int i = Arrays.binarySearch((Object[])arr, o);
            if (i < 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

