/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import de.tsl2.nano.collection.FilteringIterator;
import de.tsl2.nano.collection.MapEntrySet;
import de.tsl2.nano.collection.TransformingIterator;
import de.tsl2.nano.core.IPredicate;
import de.tsl2.nano.core.ITransformer;
import de.tsl2.nano.core.ManagedException;
import de.tsl2.nano.core.cls.BeanAttribute;
import de.tsl2.nano.core.util.ListSet;
import de.tsl2.nano.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CollectionUtil
extends de.tsl2.nano.core.util.CollectionUtil {
    public static final <T> ListSet<T> asListSet(Collection<T> listOrSet) {
        if (listOrSet instanceof ListSet) {
            return (ListSet)listOrSet;
        }
        return new ListSet(listOrSet);
    }

    public static <S, T> Collection<T> getTransformedCollection(Collection<S> toTransform, String attributeName) {
        return CollectionUtil.getTransformedCollection(toTransform, attributeName, Object.class);
    }

    public static <S, T> Collection<T> getTransformedCollection(Collection<S> toTransform, final String attributeName, Class<T> transformedType) {
        ITransformer transformer = new ITransformer<S, T>(){
            BeanAttribute attribute = null;

            public T transform(S arg0) {
                if (this.attribute == null) {
                    this.attribute = BeanAttribute.getBeanAttribute(arg0.getClass(), (String)attributeName);
                }
                return this.attribute.getValue(arg0);
            }
        };
        return CollectionUtil.getList(CollectionUtil.getTransforming(toTransform, transformer).iterator());
    }

    public static <S> Collection<String> toStringTransformed(Collection<S> toTransform) {
        ITransformer transformer = new ITransformer<S, String>(){

            public String transform(S arg0) {
                return arg0 != null ? arg0.toString() : "";
            }
        };
        return CollectionUtil.getList(CollectionUtil.getTransforming(toTransform, transformer).iterator());
    }

    public static <T> Collection<T> getFilteredCollection(Iterable<T> src, IPredicate<T> predicate) {
        return CollectionUtil.getList(CollectionUtil.getFiltering(src, predicate).iterator());
    }

    public static final <T> T remove(Collection<T> source, Class<T> type, String attributeName, Object value) {
        BeanAttribute attribute = BeanAttribute.getBeanAttribute(type, (String)attributeName);
        for (T t : source) {
            if (!value.equals(attribute.getValue(t))) continue;
            if (source.remove(t)) {
                return t;
            }
            return null;
        }
        return null;
    }

    public static final <T> T find(Collection<T> source, Class<T> type, String attributeName, Object value) {
        BeanAttribute attribute = BeanAttribute.getBeanAttribute(type, (String)attributeName);
        for (T t : source) {
            if (!value.equals(attribute.getValue(t))) continue;
            return t;
        }
        return null;
    }

    public static final <T> Collection<?> wrap(Collection<T> source, Class<T> type, String attributeName) {
        ArrayList<Object> wrapCollection = new ArrayList<Object>(source.size());
        BeanAttribute attribute = BeanAttribute.getBeanAttribute(type, (String)attributeName);
        for (T t : source) {
            wrapCollection.add(attribute.getValue(t));
        }
        return wrapCollection;
    }

    public static final <S, T> Collection<T> next(Iterator<S> elements, int count, ITransformer<S, T> transformer) {
        ArrayList<S> sublist = new ArrayList<S>(count);
        for (int i = 0; i < count && elements.hasNext(); ++i) {
            sublist.add(transformer != null ? transformer.transform(elements.next()) : elements.next());
        }
        return sublist;
    }

    public static final <T extends Comparable<T>> Collection<T> getFilteredBetween(Collection<T> src, T from, T to) {
        return CollectionUtil.getList(CollectionUtil.getFilteringBetween(src, from, to).iterator());
    }

    public static final <T> Collection<T> getFilteredBetween(Collection<T> src, T from, T to, boolean ignoreCase) {
        return CollectionUtil.getList(CollectionUtil.getFilteringBetween(src, from, to, ignoreCase).iterator());
    }

    public static final <I extends Iterable<T>, T> I getFiltering(I src, IPredicate<T> filter) {
        return FilteringIterator.getFilteringIterable(src, filter);
    }

    public static final <I extends Map<S, T>, S, T extends Comparable<T>> I getFilteringMapKey(I src, IPredicate<T> filter) {
        return FilteringIterator.getFilteringMap(src, filter);
    }

    public static final <I extends Iterable<T>, T> I getFiltering(I src, final StringBuilder expression) {
        return FilteringIterator.getFilteringIterable(src, new IPredicate<T>(){

            public boolean eval(T arg0) {
                String arg = arg0 != null ? arg0.toString() : "";
                return arg.matches(expression.toString());
            }
        });
    }

    public static final <I extends Iterable<T>, T extends Comparable<T>> I getFilteringBetween(I src, final T from, final T to) {
        if (from == null && to == null) {
            return src;
        }
        final boolean useNull = from == null || to == null;
        return FilteringIterator.getFilteringIterable(src, new IPredicate<T>(){

            public boolean eval(T arg) {
                return arg == null && useNull || (from == null || arg.compareTo((Comparable)from) >= 0) && (to == null || arg.compareTo((Comparable)to) <= 0);
            }
        });
    }

    public static final <I extends Iterable<T>, T> I getFilteringBetween(I src, final T from, final T to, final boolean ignoreCase) {
        if (from == null && to == null) {
            return src;
        }
        return FilteringIterator.getFilteringIterable(src, new IPredicate<T>(){

            public boolean eval(T arg0) {
                boolean useNull;
                String sto;
                String sfrom;
                String string = from != null && !ObjectUtil.isEmpty((Object)from) ? (ignoreCase && from.toString() != null ? from.toString().toUpperCase() : from.toString()) : (sfrom = null);
                if ("*".equals(sfrom)) {
                    sfrom = null;
                }
                String string2 = to != null && !ObjectUtil.isEmpty((Object)to) ? (ignoreCase && to.toString() != null ? to.toString().toUpperCase() : to.toString()) : (sto = null);
                if ("*".equals(sto)) {
                    sto = null;
                }
                boolean bl = useNull = from == null || to == null;
                String sarg = arg0 != null ? (ignoreCase && arg0.toString() != null ? arg0.toString().toUpperCase() : arg0.toString()) : null;
                return sarg == null && useNull || (sfrom == null || sarg.compareTo(sfrom) >= 0) && (sto == null || sarg.compareTo(sto) <= 0);
            }
        });
    }

    public static final <I extends Iterable<T>, S, T> I getTransforming(Iterable<S> src, ITransformer<S, T> transformer) {
        return TransformingIterator.getTransformingIterable(src, transformer);
    }

    public static final <I extends Iterable<T>, S, T> I getTransforming(Iterable<S> src, ITransformer<S, T> transformer, IPredicate<T> filter) {
        return TransformingIterator.getTransformingIterable(CollectionUtil.getFiltering(src, filter), transformer);
    }

    public static <K, V> Set<Map.Entry<K, V>> asEntrySetExtender(Map<K, V> m) {
        return new MapEntrySet<K, V>(m);
    }

    public static final Collection<?> getContainer(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            return CollectionUtil.asList((Object)obj);
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return (Collection)obj;
        }
        if (Map.class.isAssignableFrom(cls)) {
            return CollectionUtil.asEntrySetExtender((Map)obj);
        }
        throw new ManagedException(obj + " is not a container!", new Object[0]);
    }
}

