/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import de.tsl2.nano.core.cls.PrivateAccessor;
import de.tsl2.nano.core.log.LogFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class ExpiringMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(ExpiringMap.class);
    Map<K, Long> touches;
    int capacity;
    long timeout;

    public ExpiringMap(long timeout) {
        this.init(timeout);
    }

    public ExpiringMap(int initialCapacity, float loadFactor, boolean accessOrder, long timeout) {
        super(initialCapacity, loadFactor, accessOrder);
        this.init(timeout);
    }

    public ExpiringMap(int initialCapacity, float loadFactor, long timeout) {
        super(initialCapacity, loadFactor);
        this.init(timeout);
    }

    public ExpiringMap(int initialCapacity, long timeout) {
        super(initialCapacity);
        this.init(timeout);
    }

    public ExpiringMap(Map<? extends K, ? extends V> m, long timeout) {
        super(m);
        this.init(timeout);
    }

    @Override
    public V get(Object key) {
        if (this.timeout != -1L) {
            Long access = this.touches.get(key);
            if (access != null && System.currentTimeMillis() - access > this.timeout) {
                this.remove(key);
                return null;
            }
            this.touch(key);
        }
        return super.get(key);
    }

    private void touch(K key) {
        this.touches.put(key, System.currentTimeMillis());
    }

    @Override
    public V put(K key, V value) {
        if (this.timeout != -1L) {
            this.touch(key);
            this.shrink();
        }
        return super.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.timeout != -1L) {
            this.touches.remove(key);
        }
        return super.remove(key);
    }

    @Override
    public void clear() {
        if (this.timeout != -1L) {
            this.touches.clear();
        }
        super.clear();
    }

    protected void shrink() {
        if (this.size() >= this.capacity) {
            long now = System.currentTimeMillis();
            Set entries = this.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (now - this.touches.get(entry.getKey()) <= this.timeout) continue;
                LOG.info((Object)("removing expired entry " + entry));
                iterator.remove();
            }
            this.refreshCapacity();
        }
    }

    protected void init(long timeout) {
        if (timeout != -1L) {
            this.touches = new HashMap<K, Long>();
            Set ks = this.keySet();
            long now = System.currentTimeMillis();
            for (Object k : ks) {
                this.touches.put(k, now);
            }
            this.refreshCapacity();
        }
        this.timeout = timeout;
    }

    void refreshCapacity() {
        try {
            this.capacity = (Integer)new PrivateAccessor((Object)this).call("capacity", Integer.class, new Object[0]);
        }
        catch (Exception ex) {
            LOG.warn((Object)ex.toString());
            this.capacity = this.size();
        }
    }
}

