/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import de.tsl2.nano.collection.IterableInvocationHandler;
import de.tsl2.nano.core.IPredicate;
import de.tsl2.nano.core.cls.BeanClass;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class FilteringIterator<E>
implements ListIterator<E> {
    Iterable<E> parent;
    Iterator<E> previewIt;
    IPredicate<E> predicate;
    int i = 0;
    boolean previewing;
    E item;
    int size = -1;

    public FilteringIterator(Iterable<E> parent, IPredicate<E> predicate) {
        this.parent = parent;
        this.predicate = predicate;
        this.previewIt = parent instanceof List ? ((List)parent).listIterator() : parent.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.preview() != null;
    }

    private E preview() {
        while (this.previewIt.hasNext()) {
            E n = this.previewIt.next();
            if (!this.predicate.eval(n)) continue;
            this.previewing = true;
            ++this.i;
            this.item = n;
            return this.item;
        }
        this.size = this.i;
        return null;
    }

    @Override
    public E next() {
        if (!this.previewing) {
            this.preview();
        }
        this.previewing = false;
        return this.item;
    }

    @Override
    public void remove() {
        --this.size;
        this.previewIt.remove();
    }

    @Override
    public boolean hasPrevious() {
        return this.backview() != null;
    }

    private E backview() {
        ListIterator it = (ListIterator)this.previewIt;
        while (it.hasPrevious()) {
            Object n = it.previous();
            if (!this.predicate.eval(n)) continue;
            this.previewing = true;
            --this.i;
            this.item = n;
            return this.item;
        }
        return null;
    }

    @Override
    public E previous() {
        if (!this.previewing) {
            this.backview();
        }
        this.previewing = false;
        return this.item;
    }

    @Override
    public int nextIndex() {
        this.preview();
        return this.i;
    }

    @Override
    public int previousIndex() {
        this.backview();
        return this.i;
    }

    @Override
    public void set(E e) {
        ((ListIterator)this.previewIt).set(e);
    }

    @Override
    public void add(E e) {
        if (this.size > 0) {
            ++this.size;
        }
        ((ListIterator)this.previewIt).add(e);
    }

    protected int size() {
        if (this.size < 0) {
            this.size = 0;
            FilteringIterator<E> iterator = new FilteringIterator<E>(this.parent, this.predicate);
            while (iterator.hasNext()) {
                iterator.next();
                ++this.size;
            }
        }
        return this.size;
    }

    public static Iterable getIterable(Proxy proxy) {
        return ((IterableInvocationHandler)Proxy.getInvocationHandler(proxy)).getIterable();
    }

    public static <I extends Iterable<T>, T> I getFilteringIterable(I iterable, IPredicate<T> predicate) {
        return (I)((Iterable)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), BeanClass.getBeanClass(iterable.getClass()).getInterfaces(), new IterableInvocationHandler<I, T>(iterable, predicate)));
    }

    public static <I extends Map<S, T>, S, T> I getFilteringMap(I map, IPredicate<T> predicate) {
        return (I)((Map)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), BeanClass.getBeanClass(map.getClass()).getInterfaces(), new IterableInvocationHandler<Set<S>, T>(map.keySet(), predicate)));
    }
}

