/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import java.util.ArrayList;
import java.util.List;

public class FloatArray {
    List<float[]> seg;
    int elements = 0;
    int arraysize = 0;
    int capacity;
    int segmentation;
    static final int DEFAULT_SEGMENTATION = 50;
    static final int DEFAULT_CAPACITY = 50;

    public FloatArray() {
        this(50, 50);
    }

    public FloatArray(int segmentation, int capacity) {
        this.segmentation = segmentation;
        this.capacity = capacity;
        this.seg = new ArrayList<float[]>(capacity);
    }

    public float get(int index) {
        int iseg = index / this.segmentation;
        int iarr = index % this.segmentation;
        return this.seg.get(iseg)[iarr];
    }

    public void add(float newNumber) {
        float[] s;
        if (this.elements == this.arraysize) {
            s = new float[this.segmentation];
            this.arraysize += this.segmentation;
            this.seg.add(s);
        } else {
            s = this.seg.get(this.seg.size() - 1);
        }
        s[this.elements % this.segmentation] = newNumber;
        ++this.elements;
    }

    public int size() {
        return this.elements;
    }

    public void clear() {
        this.elements = 0;
    }

    public float[] toArray() {
        int c;
        float[] arr = new float[this.elements];
        int size = this.seg.size();
        for (c = 0; c < size - 1; ++c) {
            System.arraycopy(this.seg.get(c), 0, arr, c * this.segmentation, this.segmentation);
        }
        if (size > 0) {
            int rest = this.elements - c * this.segmentation;
            System.arraycopy(this.seg.get(size - 1), 0, arr, c * this.segmentation, rest);
        }
        return arr;
    }
}

