/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import de.tsl2.nano.collection.Entry;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MapEntrySet<K, V>
extends LinkedHashSet<Entry<K, V>> {
    private static final long serialVersionUID = -7564082533237090900L;
    Map<K, V> map;
    boolean sync = true;
    private boolean internal;

    public MapEntrySet(Map<K, V> map) {
        this.map = map;
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        this.internal = true;
        for (Map.Entry<K, V> entry : entrySet) {
            this.add(new Entry<K, V>(entry, !this.sync, map));
        }
        this.internal = false;
    }

    public Map<K, V> map() {
        for (Map.Entry e : this) {
            this.map.put(e.getKey(), e.getValue());
        }
        return this.map;
    }

    @Override
    public boolean add(Entry<K, V> e) {
        if (e == null) {
            return false;
        }
        boolean result = super.add(e);
        if (result && e.getKey() != null && !this.internal && this.sync) {
            this.map.put(e.getKey(), e.getValue());
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        if (result && !this.internal && this.sync) {
            this.map.remove(((Map.Entry)o).getKey());
        }
        return result;
    }

    public void setDirectSynchronization(boolean sync) {
        this.sync = sync;
    }

    public Entry<K, V> add(K key, V value) {
        Entry<K, V> e = new Entry<K, V>(key, value);
        return this.add(e) ? e : null;
    }
}

