/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import de.tsl2.nano.collection.ReferenceMap;
import de.tsl2.nano.core.ENV;
import de.tsl2.nano.core.ManagedException;
import de.tsl2.nano.core.log.LogFactory;
import de.tsl2.nano.core.serialize.XmlUtil;
import java.io.File;
import org.apache.commons.logging.Log;

public class PersistentCache {
    static transient PersistentCache self = null;
    static transient String cacheFilePath;
    ReferenceMap cache = null;
    private static final Log LOG;

    private PersistentCache() {
        assert (self == null) : "don't call this constructor. only for internal use!";
        this.cache = new ReferenceMap();
    }

    public static final PersistentCache instance() {
        PersistentCache.checkInstance();
        return self;
    }

    public static PersistentCache createInstance(String cachePath) {
        assert (self == null) : "cache already initialized!";
        self = new PersistentCache();
        cacheFilePath = cachePath + "/tsl2nano-persistentcache.xml";
        try {
            if (new File(cacheFilePath).exists()) {
                XmlUtil cfr_ignored_0 = (XmlUtil)ENV.get(XmlUtil.class);
                PersistentCache.self.cache = (ReferenceMap)XmlUtil.loadXml((String)cacheFilePath, ReferenceMap.class);
            }
        }
        catch (Exception e) {
            ManagedException.forward((Throwable)e);
        }
        return self;
    }

    public static boolean isCreated() {
        return self != null;
    }

    public Object put(Object key, Object value) {
        Object result = this.cache.put(key, value);
        try {
            XmlUtil cfr_ignored_0 = (XmlUtil)ENV.get(XmlUtil.class);
            XmlUtil.saveXml((String)cacheFilePath, (Object)this.cache);
        }
        catch (Exception e) {
            ManagedException.forward((Throwable)e);
        }
        return result;
    }

    public Object remove(Object key) {
        Object result = this.cache.remove(key);
        try {
            XmlUtil cfr_ignored_0 = (XmlUtil)ENV.get(XmlUtil.class);
            XmlUtil.saveXml((String)cacheFilePath, (Object)this.cache);
        }
        catch (Exception e) {
            ManagedException.forward((Throwable)e);
        }
        return result;
    }

    public Object get(Object key) {
        PersistentCache.checkInstance();
        return this.cache.get(key);
    }

    public boolean deleteCache() {
        PersistentCache.checkInstance();
        this.cache.clear();
        LOG.info((Object)("deleting cache file '" + cacheFilePath + "'"));
        return new File(cacheFilePath).delete();
    }

    private static final void checkInstance() {
        assert (self != null) : "please call createInstance(.) before using it!";
        if (self == null) {
            LOG.warn((Object)"No instance initialized for caching - perhaps loaded through new classloader");
            PersistentCache.createInstance(System.getProperty("user.home"));
        }
    }

    public static void clearCache() {
        self = null;
    }

    static {
        LOG = LogFactory.getLog(PersistentCache.class);
    }
}

