/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ReferenceMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, Reference<V>> hash = new HashMap<K, Reference<V>>();
    private final Map<Reference<V>, K> reverseLookup = new HashMap<Reference<V>, K>();
    private final transient ReferenceQueue<V> queue = new ReferenceQueue();
    private boolean weak = true;

    public ReferenceMap() {
        this(true);
    }

    public ReferenceMap(boolean weak) {
        this.weak = weak;
    }

    protected Reference<V> createReference(V value, ReferenceQueue<V> queue) {
        return this.weak ? new WeakReference<V>(value, queue) : new SoftReference<V>(value, queue);
    }

    @Override
    public V get(Object key) {
        this.expungeStaleEntries();
        V result = null;
        Reference<V> soft_ref = this.hash.get(key);
        if (soft_ref != null && (result = (V)soft_ref.get()) == null) {
            this.hash.remove(key);
            this.reverseLookup.remove(soft_ref);
        }
        return result;
    }

    private void expungeStaleEntries() {
        Reference<V> sv;
        while ((sv = this.queue.poll()) != null) {
            this.hash.remove(this.reverseLookup.remove(sv));
        }
    }

    @Override
    public V put(K key, V value) {
        this.expungeStaleEntries();
        Reference<V> soft_ref = this.createReference(value, this.queue);
        this.reverseLookup.put((Reference<K>)soft_ref, (Reference<V>)key);
        Reference<V> result = this.hash.put(key, soft_ref);
        if (result == null) {
            return null;
        }
        this.reverseLookup.remove(result);
        return result.get();
    }

    @Override
    public V remove(Object key) {
        this.expungeStaleEntries();
        Reference<V> result = this.hash.remove(key);
        if (result == null) {
            return null;
        }
        return result.get();
    }

    @Override
    public void clear() {
        this.hash.clear();
        this.reverseLookup.clear();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.hash.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expungeStaleEntries();
        LinkedHashSet<Map.Entry<K, V>> result = new LinkedHashSet<Map.Entry<K, V>>();
        for (final Map.Entry<K, Reference<V>> entry : this.hash.entrySet()) {
            final V value = entry.getValue().get();
            if (value == null) continue;
            result.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V v) {
                    entry.setValue(ReferenceMap.this.createReference(v, ReferenceMap.this.queue));
                    return value;
                }
            });
        }
        return result;
    }
}

