/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;

public class SegmentList<TARRAY, T>
extends ArrayList<TARRAY> {
    private static final long serialVersionUID = -691507232535252240L;
    Class<T> type;
    protected int capacity;
    protected static final int DEFAULT_SEGMENTATION = 50;
    protected static final int DEFAULT_CAPACITY = 50;

    public SegmentList() {
        this(Object.class, 50);
    }

    public SegmentList(Class<T> type) {
        this(type, 50);
    }

    public SegmentList(Class<T> type, int capacity) {
        super(capacity);
        this.type = type;
        this.capacity = capacity;
    }

    TARRAY newArraySegment(int size) {
        return (TARRAY)Array.newInstance(this.type, size);
    }

    public int elementCount() {
        int c = 0;
        for (Object s : this) {
            c += Array.getLength(s);
        }
        return c;
    }

    public TARRAY toSegmentArray() {
        TARRAY arr = this.newArraySegment(this.elementCount());
        int off = 0;
        int segment = 0;
        for (Object af : this) {
            segment = Array.getLength(af);
            System.arraycopy(af, 0, arr, off, segment);
            off += segment;
        }
        return arr;
    }
}

