/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.collection;

import de.tsl2.nano.collection.Row;
import de.tsl2.nano.core.ManagedException;
import de.tsl2.nano.core.cls.BeanClass;
import de.tsl2.nano.core.log.LogFactory;
import de.tsl2.nano.core.util.CollectionUtil;
import de.tsl2.nano.core.util.FileUtil;
import de.tsl2.nano.core.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.xml.sax.helpers.DefaultHandler;

public class TableList<H extends Comparable<H>, ID>
implements Serializable {
    private static final long serialVersionUID = -9192974285797951377L;
    protected String name;
    protected Class<H> headerType;
    protected H[] header;
    protected List<Row<ID>> rows;
    private static final Log LOG = LogFactory.getLog(TableList.class);
    protected static final String DIV = "\t";
    protected static final String LF = System.getProperty("line.separator");
    public static final String FILE_EXT = ".csv";
    public static final String CELL_ROOT = "--";

    protected TableList() {
    }

    public TableList(String name, int cols, int rows) {
        this(name, cols);
        this.fill(DefaultHandler.class, rows);
    }

    public TableList(String name, int columnCount) {
        this(String.class, columnCount);
        this.name = name;
    }

    public TableList(Class<H> headerType, int columnCount) {
        this((Comparable[])Array.newInstance(headerType, columnCount));
        this.headerType = headerType;
        if (headerType.equals(String.class)) {
            for (int i = 0; i < this.header.length; ++i) {
                this.header[i] = (Comparable)headerType.cast(String.valueOf(i));
            }
        } else {
            BeanClass bc = BeanClass.getBeanClass(headerType);
            for (int i = 0; i < this.header.length; ++i) {
                this.header[i] = (Comparable)bc.createInstance(new Object[0]);
            }
        }
    }

    public TableList(H ... header) {
        this(header.length > 0 && header[0] != null ? header[0].getClass() : Object.class, (Comparable[])header);
    }

    protected TableList(Class<H> headerType, H ... header) {
        assert (header != null && header.length > 0);
        this.header = header;
        this.headerType = headerType;
        this.rows = new ArrayList<Row<ID>>();
    }

    public <T extends TableList<H, ID>> T fill(int rowCount) {
        return this.fill(Row.class, rowCount);
    }

    public <T extends TableList<H, ID>> T fill(Class<ID> idType, int rowCount) {
        return this.fill((Object[])Array.newInstance(idType, rowCount));
    }

    public <T extends TableList<H, ID>> T fill(ID ... ids) {
        if (this.rows instanceof ArrayList) {
            ((ArrayList)this.rows).ensureCapacity(ids.length);
        }
        for (int i = 0; i < ids.length; ++i) {
            this.add(ids[i], null);
        }
        return (T)this;
    }

    public H[] getHeader() {
        return this.header;
    }

    public String[] getColumns() {
        if (this.headerType.equals(String.class)) {
            return (String[])String[].class.cast(this.header);
        }
        String[] columns = new String[this.header.length];
        for (int i = 0; i < this.header.length; ++i) {
            columns[i] = this.header[i].toString();
        }
        return columns;
    }

    public TableList<H, ID> addAll(boolean includedRowIds, List values) {
        return this.addAll(includedRowIds, values.toArray());
    }

    public TableList<H, ID> addAll(boolean includedRowIds, Object ... values) {
        int colSize = this.getColumnCount() + (includedRowIds ? 1 : 0);
        Object[][] rows = CollectionUtil.split((Object[])values, (int)colSize);
        for (int i = 0; i < rows.length; ++i) {
            Object rowId = includedRowIds && i % colSize == 0 ? rows[i][0] : this.createRowID(i);
            this.add(rowId, CollectionUtil.copyOfRange((Object[])rows[i], (int)1, (int)rows[i].length));
        }
        return this;
    }

    protected ID createRowID(int i) {
        return (ID)Integer.valueOf(i);
    }

    protected Row<ID> createRow(int index, Object ... values) {
        return new Row<ID>(index, this.createRowID(index), values);
    }

    public TableList<H, ID> add(ID rowId, Object ... values) {
        return this.add(this.rows.size(), rowId, values);
    }

    public TableList<H, ID> add(int index, ID rowId, Object ... values) {
        if (values == null || values.length == 0) {
            values = new Object[this.header.length];
        }
        this.rows.add(index, new Row<ID>(index, rowId, values));
        return this;
    }

    public TableList<H, ID> set(int index, ID rowId, Object ... values) {
        if (values == null || values.length == 0) {
            values = new Object[this.header.length];
        } else {
            this.checkRowSize(values);
        }
        this.rows.set(index, new Row<ID>(index, rowId, values));
        return this;
    }

    public <S> TableList<H, ID> set(ID rowId, S ... values) {
        Object[] v = this.get(rowId);
        int count = Math.min(values.length, v.length);
        System.arraycopy(values, 0, v, 0, count);
        return this;
    }

    public TableList<H, ID> set(int row, int column, Object value) {
        this.checkSizes(row, column);
        this.rows.get((int)row).values[column] = value;
        return this;
    }

    public TableList<H, ID> set(int row, H column, Object value) {
        int c = Arrays.binarySearch(this.header, column);
        return this.set((ID)row, (H)c, value);
    }

    public TableList<H, ID> set(ID rowID, int column, Object value) {
        int r = this.indexOf(rowID);
        return this.set((ID)r, (H)column, value);
    }

    public TableList<H, ID> set(ID rowID, H column, Object value) {
        int r = this.indexOf(rowID);
        return this.set((ID)r, column, value);
    }

    public Object remove(ID rowId) {
        for (Row<ID> r : this.rows) {
            if (!r.rowId.equals(rowId)) continue;
            return this.rows.remove(r);
        }
        return null;
    }

    public Row<ID> remove(int index) {
        return this.rows.remove(index);
    }

    public Object get(int row, int column) {
        this.checkSizes(row, column);
        return this.rows.get((int)row).values[column];
    }

    public Object get(ID row, H column) {
        int i = this.indexOf(row);
        return this.get(i, column);
    }

    public Object get(int row, H column) {
        int i = Arrays.binarySearch(this.header, column);
        return this.get(row, i);
    }

    public ID getRowID(int row) {
        return this.rows.get((int)row).rowId;
    }

    public Object[] get(ID rowId) {
        int i = this.indexOf(rowId);
        return this.rows.get((int)i).values;
    }

    public <S> S[] get(ID rowId, Class<S> arrayType) {
        Object[] objects = this.get(rowId);
        Object[] arr = (Object[])Array.newInstance(arrayType, objects.length);
        System.arraycopy(objects, 0, arr, 0, objects.length);
        return arr;
    }

    public Object get(ID rowId, int column) {
        return this.get(this.indexOf(rowId), column);
    }

    public int indexOf(ID rowId) {
        Row.temp.rowId = rowId;
        if (rowId.equals(0)) {
            return -1;
        }
        int i = this.rows.indexOf(Row.temp);
        if (i == -1) {
            throw new IllegalArgumentException("The row-id " + rowId + " couldn't be found on table " + this);
        }
        return i;
    }

    public int size() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.header.length;
    }

    public int getRowCount() {
        return this.size();
    }

    protected final void checkSizes(int row, int column) {
        if (LOG.isDebugEnabled()) {
            this.checkRowSize(row);
            this.checkColumnSize(column);
        }
    }

    protected final void checkRowSize(int row) {
        if (row == -1 || row >= this.rows.size()) {
            throw new IllegalArgumentException("The given row index " + row + " is unavailable. Only " + this.rows.size() + " rows are available!");
        }
    }

    protected final void checkColumnSize(int column) {
        if (column == -1 || column >= this.header.length) {
            LOG.debug((Object)this.dump());
            throw new IllegalArgumentException("The given column index " + column + " is unavailable. Only " + this.header.length + " columns are available!");
        }
    }

    protected final void checkRowSize(Object ... values) {
        assert (values.length != this.header.length) : "value array must have same size as header array!";
    }

    public void save(String relDir) {
        String path = relDir + this.name + FILE_EXT;
        new File(path).getParentFile().mkdirs();
        FileUtil.writeBytes((byte[])this.dump().getBytes(), (String)path, (boolean)false);
    }

    public String getName() {
        return this.name;
    }

    public static <T> T load(String file) {
        return (T)TableList.load(file, TableList.class);
    }

    public static <T extends TableList> T load(String file, Class<T> type) {
        return TableList.load(file, type, DIV);
    }

    public static <T extends TableList> T load(String file, Class<T> type, String div) {
        TableList logic = null;
        try {
            Scanner sc = new Scanner(new File(file).getAbsoluteFile());
            if (sc.hasNextLine()) {
                Object[] header = sc.nextLine().split(div);
                Object[] args = new Object[1];
                String[] header1 = (String[])CollectionUtil.copyOfRange((Object[])header, (int)1, (int)header.length);
                Comparable[] h = new Comparable[header1.length];
                for (int i = 0; i < header1.length; ++i) {
                    h[i] = (Comparable)BeanClass.call(type, (String)"createDefaultHeader", (Class[])new Class[]{Object.class}, (Object[])new Object[]{header1[i]});
                }
                args[0] = h;
                logic = (TableList)BeanClass.createInstance(type, (Object[])args);
                logic.name = StringUtil.substring((String)file, (String)"/", (String)".", (boolean)true);
                while (sc.hasNextLine()) {
                    Object[] ss = sc.nextLine().split(div);
                    Object[] row = CollectionUtil.copyOfRange((Object[])ss, (int)0, (int)ss.length, Object[].class);
                    logic.addAll(true, row);
                }
            }
        }
        catch (FileNotFoundException e) {
            ManagedException.forward((Throwable)e);
        }
        return (T)logic;
    }

    protected static Object createDefaultHeader(Object source) {
        return source;
    }

    public String dump() {
        return this.dump(DIV, true);
    }

    public String dump(String div, boolean resolve) {
        StringBuilder buf = new StringBuilder(20 + this.header.length * 5 + this.rows.size() * 20 + this.rows.size() * this.header.length * 4);
        buf.append(CELL_ROOT + div);
        for (int i = 0; i < this.header.length; ++i) {
            buf.append(this.header[i] + div);
        }
        buf.append(LF);
        this.dumpValues(buf, div, resolve);
        return buf.toString();
    }

    protected void dumpValues(StringBuilder buf, String div, boolean resolve) {
        for (Row<ID> r : this.rows) {
            buf.append(r.dump() + LF);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.header.length + ", " + this.rows.size() + "), rowIDs: " + StringUtil.toString(this.rows, (int)80);
    }
}

